/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.db.mongodb;

import com.mongodb.MongoException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.ReplaceOptions;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.bson.conversions.Bson;
import org.graylog.plugins.pipelineprocessor.db.PipelineDao;
import org.graylog.plugins.pipelineprocessor.db.PipelineService;
import org.graylog.plugins.pipelineprocessor.events.PipelinesChangedEvent;
import org.graylog.plugins.pipelineprocessor.processors.PipelineInterpreter;
import org.graylog2.database.MongoCollections;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.utils.MongoUtils;
import org.graylog2.events.ClusterEventBus;

public class MongoDbPipelineService
implements PipelineService {
    private static final RateLimitedLog log = PipelineInterpreter.getRateLimitedLog(MongoDbPipelineService.class);
    public static final String COLLECTION = "pipeline_processor_pipelines";
    private final MongoCollection<PipelineDao> collection;
    private final ClusterEventBus clusterBus;
    private final MongoUtils<PipelineDao> mongoUtils;

    @Inject
    public MongoDbPipelineService(MongoCollections mongoCollections, ClusterEventBus clusterBus) {
        this.collection = mongoCollections.collection(COLLECTION, PipelineDao.class);
        this.clusterBus = clusterBus;
        this.mongoUtils = mongoCollections.utils(this.collection);
        this.collection.createIndex(Indexes.ascending((String[])new String[]{"title"}), new IndexOptions().unique(true));
    }

    @Override
    public PipelineDao save(PipelineDao pipeline) {
        PipelineDao savedPipeline;
        String pipelineId = pipeline.id();
        if (pipelineId != null) {
            this.collection.replaceOne(MongoUtils.idEq(pipelineId), (Object)pipeline, new ReplaceOptions().upsert(true));
            savedPipeline = pipeline;
        } else {
            String insertedId = MongoUtils.insertedIdAsString(this.collection.insertOne((Object)pipeline));
            savedPipeline = pipeline.toBuilder().id(insertedId).build();
        }
        this.clusterBus.post(PipelinesChangedEvent.updatedPipelineId(savedPipeline.id()));
        return savedPipeline;
    }

    @Override
    public PipelineDao load(String id) throws NotFoundException {
        return this.mongoUtils.getById(id).orElseThrow(() -> new NotFoundException("No pipeline with id " + id));
    }

    @Override
    public PipelineDao loadByName(String name) throws NotFoundException {
        PipelineDao pipeline = (PipelineDao)this.collection.find(Filters.eq((String)"title", (Object)name)).first();
        if (pipeline == null) {
            throw new NotFoundException("No pipeline with name " + name);
        }
        return pipeline;
    }

    @Override
    public Collection<PipelineDao> loadAll() {
        try {
            return this.collection.find().into(new LinkedHashSet());
        }
        catch (MongoException e) {
            log.error("Unable to load pipelines", (Throwable)e);
            return Collections.emptySet();
        }
    }

    @Override
    public void delete(String id) {
        this.collection.deleteOne(MongoUtils.idEq(id));
        this.clusterBus.post(PipelinesChangedEvent.deletedPipelineId(id));
    }

    public long count(Bson filter) {
        return this.collection.countDocuments(filter);
    }
}

