/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.db;

import com.google.common.collect.ImmutableSet;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.result.InsertOneResult;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchRequirements;
import org.graylog.plugins.views.search.SearchSummary;
import org.graylog.plugins.views.search.searchfilters.db.SearchFiltersReFetcher;
import org.graylog.plugins.views.search.views.PluginMetadataSummary;
import org.graylog2.database.MongoCollections;
import org.graylog2.database.utils.MongoUtils;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class SearchDbService {
    protected final MongoCollection<Search> db;
    protected final MongoCollection<SearchSummary> summarydb;
    private final SearchRequirements.Factory searchRequirementsFactory;
    private final SearchFiltersReFetcher searchFiltersRefetcher;
    private final MongoUtils<Search> mongoUtils;

    @Inject
    protected SearchDbService(MongoCollections mongoCollections, SearchRequirements.Factory searchRequirementsFactory, SearchFiltersReFetcher searchFiltersRefetcher) {
        this.searchRequirementsFactory = searchRequirementsFactory;
        this.db = mongoCollections.collection("searches", Search.class);
        this.db.createIndex(Indexes.ascending((String[])new String[]{"created_at"}));
        this.summarydb = mongoCollections.collection("searches", SearchSummary.class);
        this.searchFiltersRefetcher = searchFiltersRefetcher;
        this.mongoUtils = mongoCollections.utils(this.db);
    }

    public Optional<Search> get(String id) {
        return this.mongoUtils.getById(id).map(this::getSearchWithRefetchedFilters).map(this::requirementsForSearch);
    }

    private Search getSearchWithRefetchedFilters(Search search) {
        if (this.searchFiltersRefetchNeeded(search)) {
            return search.toBuilder().queries((ImmutableSet<Query>)((ImmutableSet)search.queries().stream().map(query -> query.toBuilder().filters(this.searchFiltersRefetcher.reFetch(query.filters())).build()).collect(ImmutableSet.toImmutableSet()))).build();
        }
        return search;
    }

    private boolean searchFiltersRefetchNeeded(Search search) {
        return this.searchFiltersRefetcher.turnedOn() && search.queries().stream().anyMatch(Query::hasReferencedStreamFilters);
    }

    public Search save(Search search) {
        Search searchToSave = this.requirementsForSearch(search);
        if (searchToSave.id() != null) {
            this.db.replaceOne(MongoUtils.idEq(search.id()), (Object)searchToSave, new ReplaceOptions().upsert(true));
            return searchToSave;
        }
        InsertOneResult save = this.db.insertOne((Object)searchToSave);
        return this.get(MongoUtils.insertedIdAsString(save)).orElseThrow(() -> new IllegalStateException("Unable to retrieve saved search!"));
    }

    void delete(String id) {
        this.mongoUtils.getById(id);
    }

    public Collection<Search> findByIds(Set<String> idSet) {
        return MongoUtils.stream(this.db.find(MongoUtils.stringIdsIn(idSet))).map(this::getSearchWithRefetchedFilters).map(this::requirementsForSearch).collect(Collectors.toList());
    }

    public Stream<Search> streamAll() {
        return MongoUtils.stream(this.db.find()).map(this::getSearchWithRefetchedFilters).map(this::requirementsForSearch);
    }

    private Search requirementsForSearch(Search search) {
        return this.searchRequirementsFactory.create(search).rebuildRequirements(Search::requires, (s, newRequirements) -> s.toBuilder().requires((Map<String, PluginMetadataSummary>)newRequirements).build());
    }

    Stream<SearchSummary> findSummaries() {
        return MongoUtils.stream(this.summarydb.find());
    }

    public Set<String> getExpiredSearches(Set<String> neverDeleteIds, Instant mustBeOlderThan) {
        return this.findSummaries().filter(search -> !neverDeleteIds.contains(search.id()) && search.createdAt().isBefore((ReadableInstant)mustBeOlderThan)).map(SearchSummary::id).collect(Collectors.toSet());
    }
}

