/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.engine.monitoring.data.histogram.rest;

import au.com.bytecode.opencsv.CSVWriter;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.graylog.plugins.views.search.engine.monitoring.data.histogram.Histogram;

@Provider
@Produces(value={"application/json", "text/csv"})
public class HistogramResponseWriter
implements MessageBodyWriter<Histogram> {
    private final ObjectMapper objectMapper;

    @Inject
    public HistogramResponseWriter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean isWriteable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return aClass.equals(Histogram.class);
    }

    public void writeTo(Histogram histogram, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> multivaluedMap, OutputStream outputStream) throws IOException, WebApplicationException {
        switch (mediaType.toString()) {
            case "application/json": {
                this.writeJson(histogram, outputStream);
                break;
            }
            case "text/csv": {
                this.writeCsv(histogram, outputStream);
                break;
            }
            default: {
                throw new IllegalArgumentException("Media type " + mediaType + " not supported");
            }
        }
    }

    private void writeJson(Histogram histogram, OutputStream outputStream) throws IOException {
        this.objectMapper.writeValue(outputStream, (Object)histogram);
    }

    private void writeCsv(Histogram histogram, OutputStream outputStream) throws IOException {
        try (CSVWriter csvWriter = new CSVWriter((Writer)new PrintWriter(outputStream, true, StandardCharsets.UTF_8), ',', '\u0000');){
            List<String> schema = histogram.schema();
            csvWriter.writeNext(schema.toArray(new String[0]));
            histogram.bins().stream().map(bin -> bin.toDataLine().toArray(new String[0])).forEach(arg_0 -> ((CSVWriter)csvWriter).writeNext(arg_0));
        }
    }
}

