/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.searchtypes.export;

import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.graylog.plugins.views.search.searchtypes.export.ExportTabularResultResponse;

public class XLSXWriter {
    public static void writeXlsx(ExportTabularResultResponse widgetExportResponse, OutputStream outputStream) throws IOException {
        try (XSSFWorkbook wb = new XSSFWorkbook();){
            XLSXWriter.createWorksheetFor(wb, "export", widgetExportResponse);
            wb.write(outputStream);
        }
    }

    public static void createWorksheetFor(XSSFWorkbook wb, String sheetName, ExportTabularResultResponse data) {
        XSSFSheet sheet = wb.createSheet(sheetName);
        XSSFRow row = sheet.createRow(0);
        for (int c = 0; c < data.header().size(); ++c) {
            XSSFCell cell = row.createCell(c);
            cell.setCellValue(data.header().get(c));
        }
        for (int r = 0; r < data.dataRows().size(); ++r) {
            row = sheet.createRow(r + 1);
            List<Object> rowData = data.dataRows().get(r).row();
            for (int c = 0; c < rowData.size(); ++c) {
                XSSFCell cell = row.createCell(c);
                Object rawData = rowData.get(c);
                if (rawData instanceof Integer) {
                    Integer i = (Integer)rawData;
                    cell.setCellValue((double)i.intValue());
                    continue;
                }
                if (rawData instanceof Double) {
                    Double d = (Double)rawData;
                    cell.setCellValue(d.doubleValue());
                    continue;
                }
                if (rawData instanceof Boolean) {
                    Boolean b = (Boolean)rawData;
                    cell.setCellValue(b.booleanValue());
                    continue;
                }
                if (rawData instanceof Date) {
                    Date d = (Date)rawData;
                    cell.setCellValue(d);
                    continue;
                }
                if (rawData instanceof LocalDateTime) {
                    LocalDateTime ldt = (LocalDateTime)rawData;
                    cell.setCellValue(ldt);
                    continue;
                }
                if (rawData instanceof Calendar) {
                    Calendar cal = (Calendar)rawData;
                    cell.setCellValue(cal);
                    continue;
                }
                if (rawData instanceof String) {
                    String s = (String)rawData;
                    cell.setCellValue(s);
                    continue;
                }
                if (rawData instanceof RichTextString) {
                    RichTextString rts = (RichTextString)rawData;
                    cell.setCellValue(rts);
                    continue;
                }
                if (rawData instanceof LocalDate) {
                    LocalDate ld = (LocalDate)rawData;
                    cell.setCellValue(ld);
                    continue;
                }
                if (rawData != null) {
                    cell.setCellValue(rawData.toString());
                    continue;
                }
                cell.setBlank();
            }
        }
    }
}

