/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.shares;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNDescriptor;
import org.graylog.grn.GRNDescriptorService;
import org.graylog.grn.GRNRegistry;
import org.graylog.security.Capability;
import org.graylog.security.DBGrantService;
import org.graylog.security.GrantDTO;
import org.graylog.security.entities.EntityDescriptor;
import org.graylog.security.shares.AutoValue_GranteeSharesService_SharesResponse;
import org.graylog.security.shares.Grantee;
import org.graylog.security.shares.GranteeService;
import org.graylog2.database.PaginatedList;
import org.graylog2.rest.PaginationParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GranteeSharesService {
    private static final Logger LOG = LoggerFactory.getLogger(GranteeSharesService.class);
    private final DBGrantService grantService;
    private final GRNDescriptorService descriptorService;
    private final GranteeService granteeService;

    @Inject
    public GranteeSharesService(DBGrantService grantService, GRNDescriptorService descriptorService, GranteeService granteeService) {
        this.grantService = grantService;
        this.descriptorService = descriptorService;
        this.granteeService = granteeService;
    }

    public SharesResponse getPaginatedSharesFor(GRN grantee, PaginationParameters paginationParameters, String capabilityFilterString, String entityTypeFilterString) {
        Optional<Capability> capability = this.parseCapabilityFilter(capabilityFilterString);
        Set<GRN> granteeAliases = this.granteeService.getGranteeAliases(grantee);
        ImmutableSet grants = capability.map(c -> this.grantService.getForGranteesOrGlobalWithCapability(granteeAliases, (Capability)((Object)c))).orElseGet(() -> this.grantService.getForGranteesOrGlobal(granteeAliases));
        Set<GRN> targets = grants.stream().map(GrantDTO::target).collect(Collectors.toSet());
        Map<GRN, Set<Grantee>> targetOwners = this.getTargetOwners(targets);
        Supplier<Stream> filteredStream = () -> targets.stream().map(this.descriptorService::getDescriptor).filter(this.queryPredicate(paginationParameters)).filter(this.entityTypeFilterPredicate(entityTypeFilterString)).map(this.toEntityDescriptor(targetOwners)).sorted(Comparator.comparing(EntityDescriptor::title, (t1, t2) -> {
            if (paginationParameters.getOrder().toLowerCase(Locale.US).equals("desc")) {
                return t2.compareTo((String)t1);
            }
            return t1.compareTo((String)t2);
        }));
        int filteredResultCount = Ints.saturatedCast((long)filteredStream.get().count());
        List entityDescriptors = filteredStream.get().skip(paginationParameters.getPerPage() * (paginationParameters.getPage() - 1)).limit(paginationParameters.getPerPage()).collect(Collectors.toList());
        Set entityDescriptorsGRNs = entityDescriptors.stream().map(EntityDescriptor::id).collect(Collectors.toSet());
        Map<GRN, Capability> granteeCapabilities = grants.stream().filter(grant -> entityDescriptorsGRNs.contains(grant.target())).collect(Collectors.groupingBy(GrantDTO::target)).values().stream().map(grantsList -> grantsList.stream().max(Comparator.comparing(grant -> grant.capability().priority()))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(GrantDTO::target, GrantDTO::capability));
        PaginatedList<EntityDescriptor> paginatedList = new PaginatedList<EntityDescriptor>(entityDescriptors, filteredResultCount, paginationParameters.getPage(), paginationParameters.getPerPage(), Long.valueOf(targets.size()));
        return SharesResponse.create(paginatedList, granteeCapabilities);
    }

    private Function<GRNDescriptor, EntityDescriptor> toEntityDescriptor(Map<GRN, Set<Grantee>> targetOwners) {
        return grnDescriptor -> EntityDescriptor.create(grnDescriptor.grn(), grnDescriptor.title(), targetOwners.getOrDefault(grnDescriptor.grn(), Collections.emptySet()));
    }

    private Map<GRN, Set<Grantee>> getTargetOwners(Set<GRN> targets) {
        return this.grantService.getOwnersForTargets(targets).entrySet().stream().map(entry -> Maps.immutableEntry((Object)((GRN)entry.getKey()), this.getOwners((Map.Entry<GRN, Set<GRN>>)entry))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Set<Grantee> getOwners(Map.Entry<GRN, Set<GRN>> entry) {
        return this.descriptorService.getDescriptors((Collection<GRN>)entry.getValue()).stream().map(descriptor -> {
            if (descriptor.grn().equals(GRNRegistry.GLOBAL_USER_GRN)) {
                return Grantee.createGlobal();
            }
            return Grantee.create(descriptor.grn(), descriptor.grn().type(), descriptor.title());
        }).collect(Collectors.toSet());
    }

    private Optional<Capability> parseCapabilityFilter(String capabilityFilterString) {
        String capabilityFilter = ((String)MoreObjects.firstNonNull((Object)capabilityFilterString, (Object)"")).trim().toUpperCase(Locale.US);
        if (capabilityFilter.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Capability.valueOf(capabilityFilter));
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Unknown capability", (Throwable)e);
            return Optional.empty();
        }
    }

    private Predicate<GRNDescriptor> queryPredicate(PaginationParameters paginationParameters) {
        String query = ((String)MoreObjects.firstNonNull((Object)paginationParameters.getQuery(), (Object)"")).trim().toLowerCase(Locale.US);
        if (query.isEmpty()) {
            return descriptor -> true;
        }
        return descriptor -> descriptor.title().toLowerCase(Locale.US).contains(query);
    }

    private Predicate<GRNDescriptor> entityTypeFilterPredicate(String entityTypeFilter) {
        String type = ((String)MoreObjects.firstNonNull((Object)entityTypeFilter, (Object)"")).trim().toLowerCase(Locale.US);
        if (type.isEmpty()) {
            return descriptor -> true;
        }
        return descriptor -> descriptor.grn().type().equals(type);
    }

    @AutoValue
    public static abstract class SharesResponse {
        public abstract PaginatedList<EntityDescriptor> paginatedEntities();

        public abstract Map<GRN, Capability> capabilities();

        public static SharesResponse create(PaginatedList<EntityDescriptor> paginatedEntities, Map<GRN, Capability> capabilities) {
            return new AutoValue_GranteeSharesService_SharesResponse(paginatedEntities, capabilities);
        }
    }
}

