/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings.providers;

import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.Renderer;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

@Singleton
public class JsonSafeEngineProvider
implements Provider<Engine> {
    private final Engine engine = Engine.createEngine();

    @Inject
    public JsonSafeEngineProvider() {
        this.engine.registerRenderer(String.class, (Renderer)new JsonSafeRenderer());
        this.engine.registerRenderer(Map.class, (Renderer)new JsonSafeMapRenderer());
        this.engine.registerRenderer(Iterable.class, (Renderer)new JsonSafeIterableRenderer());
        this.engine.registerRenderer(Collection.class, (Renderer)new JsonSafeCollectionRenderer());
    }

    public Engine get() {
        return this.engine;
    }

    private static class JsonSafeRenderer
    implements Renderer<String> {
        private JsonSafeRenderer() {
        }

        public String render(String s, Locale locale, Map<String, Object> map) {
            return StringEscapeUtils.escapeJava((String)s).replace("/", "\\/");
        }
    }

    private static class JsonSafeMapRenderer
    implements Renderer<Map> {
        private JsonSafeMapRenderer() {
        }

        public String render(Map map, Locale locale, Map<String, Object> map2) {
            String renderedResult = map.isEmpty() ? "" : (map.size() == 1 ? map.values().iterator().next().toString() : map.toString());
            return StringEscapeUtils.escapeJava((String)renderedResult).replace("/", "\\/");
        }
    }

    private static class JsonSafeIterableRenderer
    implements Renderer<Iterable> {
        private JsonSafeIterableRenderer() {
        }

        public String render(Iterable iterable, Locale locale, Map<String, Object> model) {
            Iterator iterator = iterable.iterator();
            String renderedResult = iterator.hasNext() ? iterator.next().toString() : "";
            return StringEscapeUtils.escapeJava((String)renderedResult).replace("/", "\\/");
        }
    }

    private static class JsonSafeCollectionRenderer
    implements Renderer<Collection> {
        private JsonSafeCollectionRenderer() {
        }

        public String render(Collection collection, Locale locale, Map<String, Object> model) {
            String renderedResult = collection.isEmpty() ? "" : (collection.size() == 1 ? collection.iterator().next().toString() : collection.toString());
            return StringEscapeUtils.escapeJava((String)renderedResult).replace("/", "\\/");
        }
    }
}

