/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight;

import com.google.inject.assistedinject.FactoryModuleBuilder;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.audit.NullAuditEventSender;
import org.graylog2.bootstrap.preflight.DiskJournalPreflightCheck;
import org.graylog2.bootstrap.preflight.SearchDbPreflightCheck;
import org.graylog2.cluster.ClusterConfigServiceImpl;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.inject.Graylog2Module;
import org.graylog2.plugin.system.FilePersistedNodeIdProvider;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.security.CustomCAX509TrustManager;
import org.graylog2.security.TrustManagerProvider;
import org.graylog2.shared.bindings.providers.OkHttpClientProvider;
import org.graylog2.storage.providers.ElasticsearchVersionProvider;

public class ServerPreflightChecksModule
extends Graylog2Module {
    protected void configure() {
        this.install(new FactoryModuleBuilder().implement(TrustManager.class, CustomCAX509TrustManager.class).build(TrustManagerProvider.class));
        this.bind(X509TrustManager.class).to(CustomCAX509TrustManager.class).asEagerSingleton();
        this.bind(OkHttpClient.class).toProvider(OkHttpClientProvider.class).asEagerSingleton();
        this.bind(ElasticsearchVersionProvider.class).asEagerSingleton();
        this.bind(NodeId.class).toProvider(FilePersistedNodeIdProvider.class).asEagerSingleton();
        this.bind(AuditEventSender.class).to(NullAuditEventSender.class);
        this.bind(ClusterConfigService.class).to(ClusterConfigServiceImpl.class).asEagerSingleton();
        this.addPreflightCheck(SearchDbPreflightCheck.class);
        this.addPreflightCheck(DiskJournalPreflightCheck.class);
    }
}

