/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.filtering;

import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Predicate;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.graylog2.database.filtering.Filter;
import org.graylog2.database.filtering.inmemory.InMemoryFilterable;

public record RangeFilter(String field, Object from, Object to) implements Filter
{
    @Override
    public Bson toBson() {
        ArrayList<Bson> rangeFilters = new ArrayList<Bson>(2);
        if (this.from() != null) {
            rangeFilters.add(Filters.gte((String)this.field(), (Object)this.from()));
        }
        if (this.to() != null) {
            rangeFilters.add(Filters.lte((String)this.field(), (Object)this.to()));
        }
        if (!rangeFilters.isEmpty()) {
            return Filters.and(rangeFilters);
        }
        return new BsonDocument();
    }

    @Override
    public Predicate<InMemoryFilterable> toPredicate() {
        throw new UnsupportedOperationException("RangeFilters are only supported in MongoDB-based filtering, not in in-memory filtering.");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeFilter that = (RangeFilter)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.from, this.to);
    }
}

