/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.indices;

import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.graylog2.database.utils.MongoUtils;

public class MongoDbIndexTools<T> {
    static final String COLLATION_KEY = "collation";
    static final String INDEX_DOCUMENT_KEY = "key";
    private final MongoCollection<T> db;

    public MongoDbIndexTools(MongoCollection<T> db) {
        this.db = db;
    }

    public static void ensureTTLIndex(MongoCollection<Document> collection, Duration ttl, String fieldUpdatedAt) {
        IndexOptions indexOptions = new IndexOptions().expireAfter(Long.valueOf(ttl.getSeconds()), TimeUnit.SECONDS);
        Bson updatedAtKey = Indexes.ascending((String[])new String[]{fieldUpdatedAt});
        for (Document document : collection.listIndexes()) {
            Set keySet = ((Document)document.get((Object)INDEX_DOCUMENT_KEY, Document.class)).keySet();
            if (!keySet.contains(fieldUpdatedAt)) continue;
            long expireAfterSeconds = ((Number)document.get((Object)"expireAfterSeconds", Number.class)).longValue();
            if (Objects.equals(expireAfterSeconds, indexOptions.getExpireAfter(TimeUnit.SECONDS))) {
                return;
            }
            collection.dropIndex(updatedAtKey);
        }
        collection.createIndex(updatedAtKey, indexOptions);
    }

    public void prepareIndices(String idField, Collection<String> sortFields, Collection<String> caseInsensitiveStringSortFields) {
        if (!sortFields.containsAll(caseInsensitiveStringSortFields)) {
            throw new IllegalArgumentException("Case Insensitive String Sort Fields should be a subset of all Sort Fields ");
        }
        ListIndexesIterable existingIndices = this.db.listIndexes();
        for (String sortField : sortFields) {
            if (sortField.equals(idField)) continue;
            Optional<Document> existingIndex = this.getExistingIndex((ListIndexesIterable<Document>)existingIndices, sortField);
            if (caseInsensitiveStringSortFields.contains(sortField)) {
                if (existingIndex.isEmpty()) {
                    this.createCaseInsensitiveStringIndex(sortField);
                    continue;
                }
                if (existingIndex.get().get((Object)COLLATION_KEY) != null) continue;
                this.dropIndex(sortField);
                this.createCaseInsensitiveStringIndex(sortField);
                continue;
            }
            if (existingIndex.isEmpty()) {
                this.createSingleFieldIndex(sortField);
                continue;
            }
            if (existingIndex.get().get((Object)COLLATION_KEY) == null) continue;
            this.dropIndex(sortField);
            this.createSingleFieldIndex(sortField);
        }
    }

    private void dropIndex(String sortField) {
        this.db.dropIndex(Indexes.ascending((String[])new String[]{sortField}));
    }

    private void createSingleFieldIndex(String sortField) {
        this.db.createIndex(Indexes.ascending((String[])new String[]{sortField}), new IndexOptions().unique(false));
    }

    private void createCaseInsensitiveStringIndex(String sortField) {
        this.db.createIndex(Indexes.ascending((String[])new String[]{sortField}), new IndexOptions().collation(Collation.builder().locale("en").build()));
    }

    private Optional<Document> getExistingIndex(ListIndexesIterable<Document> existingIndices, String sortField) {
        if (existingIndices == null) {
            return Optional.empty();
        }
        return MongoUtils.stream(existingIndices).filter(info -> ((Document)info.get((Object)INDEX_DOCUMENT_KEY, Document.class)).containsKey((Object)sortField)).findFirst();
    }

    public void createUniqueIndex(String field) {
        this.db.createIndex(Indexes.ascending((String[])new String[]{field}), new IndexOptions().unique(true));
    }
}

