/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import jakarta.inject.Inject;
import org.graylog2.cluster.leader.LeaderChangedEvent;
import org.graylog2.cluster.leader.LeaderElectionService;
import org.graylog2.database.NotFoundException;
import org.graylog2.inputs.Input;
import org.graylog2.inputs.InputService;
import org.graylog2.plugin.IOState;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.lifecycles.Lifecycle;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.rest.models.system.inputs.responses.InputCreated;
import org.graylog2.rest.models.system.inputs.responses.InputDeleted;
import org.graylog2.rest.models.system.inputs.responses.InputUpdated;
import org.graylog2.shared.inputs.InputLauncher;
import org.graylog2.shared.inputs.InputRegistry;
import org.graylog2.shared.inputs.NoSuchInputTypeException;
import org.graylog2.shared.inputs.PersistedInputs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(InputEventListener.class);
    private final InputLauncher inputLauncher;
    private final InputRegistry inputRegistry;
    private final InputService inputService;
    private final NodeId nodeId;
    private final LeaderElectionService leaderElectionService;
    private final PersistedInputs persistedInputs;
    private final ServerStatus serverStatus;

    @Inject
    public InputEventListener(EventBus eventBus, InputLauncher inputLauncher, InputRegistry inputRegistry, InputService inputService, NodeId nodeId, LeaderElectionService leaderElectionService, PersistedInputs persistedInputs, ServerStatus serverStatus) {
        this.inputLauncher = inputLauncher;
        this.inputRegistry = inputRegistry;
        this.inputService = inputService;
        this.nodeId = nodeId;
        this.leaderElectionService = leaderElectionService;
        this.persistedInputs = persistedInputs;
        this.serverStatus = serverStatus;
        eventBus.register((Object)this);
    }

    @Subscribe
    public void inputCreated(InputCreated inputCreatedEvent) {
        Input input;
        String inputId = inputCreatedEvent.id();
        LOG.debug("Input created: {}", (Object)inputId);
        try {
            input = this.inputService.find(inputId);
        }
        catch (NotFoundException e) {
            LOG.warn("Received InputCreated event but could not find input {}", (Object)inputId, (Object)e);
            return;
        }
        IOState<MessageInput> inputState = this.inputRegistry.getInputState(inputId);
        if (inputState != null) {
            this.inputRegistry.remove(inputState);
        }
        if (input.isGlobal().booleanValue() || this.nodeId.getNodeId().equals(input.getNodeId())) {
            this.startInput(input);
        }
    }

    @Subscribe
    public void inputUpdated(InputUpdated inputUpdatedEvent) {
        boolean startInput;
        Input input;
        String inputId = inputUpdatedEvent.id();
        LOG.debug("Input updated: {}", (Object)inputId);
        try {
            input = this.inputService.find(inputId);
        }
        catch (NotFoundException e) {
            LOG.warn("Received InputUpdated event but could not find input {}", (Object)inputId, (Object)e);
            return;
        }
        IOState<MessageInput> inputState = this.inputRegistry.getInputState(inputId);
        if (inputState != null) {
            startInput = inputState.getState() == IOState.Type.RUNNING;
            this.inputRegistry.remove(inputState);
        } else {
            startInput = false;
        }
        if (startInput && (input.isGlobal().booleanValue() || this.nodeId.getNodeId().equals(input.getNodeId()))) {
            this.startInput(input);
        }
    }

    private void startInput(Input input) {
        MessageInput messageInput;
        try {
            messageInput = this.inputService.getMessageInput(input);
        }
        catch (NoSuchInputTypeException e) {
            LOG.warn("Input {} is of invalid type {}", new Object[]{input.toIdentifier(), input.getType(), e});
            return;
        }
        if (!this.inputLauncher.leaderStatusInhibitsLaunch(messageInput)) {
            this.startMessageInput(messageInput);
        } else {
            LOG.info("Not launching 'onlyOnePerCluster' input {} because this node is not the leader.", (Object)input.toIdentifier());
        }
    }

    private void startMessageInput(MessageInput messageInput) {
        messageInput.initialize();
        IOState<MessageInput> newInputState = this.inputLauncher.launch(messageInput);
        this.inputRegistry.add(newInputState);
    }

    @Subscribe
    public void inputDeleted(InputDeleted inputDeletedEvent) {
        LOG.debug("Input deleted: {}", (Object)inputDeletedEvent.id());
        IOState<MessageInput> inputState = this.inputRegistry.getInputState(inputDeletedEvent.id());
        if (inputState != null) {
            this.inputRegistry.remove(inputState);
        }
    }

    @Subscribe
    public void leaderChanged(LeaderChangedEvent event) {
        if (this.serverStatus.getLifecycle() == Lifecycle.STARTING) {
            LOG.debug("Ignoring LeaderChangedEvent during server startup.");
            return;
        }
        if (this.leaderElectionService.isLeader()) {
            for (MessageInput input2 : this.persistedInputs) {
                IOState<MessageInput> inputState = this.inputRegistry.getInputState(input2.getId());
                if (!input2.onlyOnePerCluster() || !input2.isGlobal().booleanValue() || inputState != null && !inputState.canBeStarted() || !this.inputLauncher.shouldStartAutomatically(input2)) continue;
                LOG.info("Got leader role. Starting input {}", (Object)input2.toIdentifier());
                this.startMessageInput(input2);
            }
        } else {
            this.inputRegistry.getRunningInputs().stream().map(IOState::getStoppable).filter(input -> input.isGlobal() != false && input.onlyOnePerCluster()).forEach(input -> {
                LOG.info("Lost leader role. Stopping input {}", (Object)input.toIdentifier());
                this.inputDeleted(InputDeleted.create(input.getId()));
            });
        }
    }
}

