/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.transports.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.commons.lang.StringUtils;

public class HttpHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private final boolean enableCors;
    private final String authorizationHeader;
    private final String authorizationHeaderValue;
    private final String path;

    public HttpHandler(boolean enableCors, String authorizationHeader, String authorizationHeaderValue, String path) {
        this.enableCors = enableCors;
        this.authorizationHeader = authorizationHeader;
        this.authorizationHeaderValue = authorizationHeaderValue;
        this.path = path;
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest request) throws Exception {
        String suppliedAuthHeaderValue;
        Channel channel = ctx.channel();
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
        HttpVersion httpRequestVersion = request.protocolVersion();
        String origin = request.headers().get((CharSequence)HttpHeaderNames.ORIGIN);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.authorizationHeader) && (StringUtils.isBlank((String)(suppliedAuthHeaderValue = request.headers().get(this.authorizationHeader))) || !suppliedAuthHeaderValue.equals(this.authorizationHeaderValue))) {
            this.writeResponse(channel, keepAlive, httpRequestVersion, HttpResponseStatus.UNAUTHORIZED, origin);
        }
        if (HttpMethod.OPTIONS.equals((Object)request.method())) {
            this.writeResponse(channel, keepAlive, httpRequestVersion, HttpResponseStatus.OK, origin);
            return;
        }
        if (!HttpMethod.POST.equals((Object)request.method())) {
            this.writeResponse(channel, keepAlive, httpRequestVersion, HttpResponseStatus.METHOD_NOT_ALLOWED, origin);
            return;
        }
        boolean correctPath = this.path.equals(request.uri());
        if (correctPath && request instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)request;
            ByteBuf buffer = fullHttpRequest.content();
            this.writeResponse(channel, keepAlive, httpRequestVersion, HttpResponseStatus.ACCEPTED, origin);
            ctx.fireChannelRead((Object)buffer.retain());
        } else {
            this.writeResponse(channel, keepAlive, httpRequestVersion, HttpResponseStatus.NOT_FOUND, origin);
        }
    }

    private void writeResponse(Channel channel, boolean keepAlive, HttpVersion httpRequestVersion, HttpResponseStatus status, String origin) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(httpRequestVersion, status);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)(keepAlive ? HttpHeaderValues.KEEP_ALIVE : HttpHeaderValues.CLOSE));
        if (this.enableCors && origin != null && !origin.isEmpty()) {
            response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)origin);
            response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)true);
            response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, (Object)"Authorization, Content-Type");
        }
        ChannelFuture channelFuture = channel.writeAndFlush((Object)response);
        channelFuture.addListener((GenericFutureListener)(keepAlive ? ChannelFutureListener.CLOSE_ON_FAILURE : ChannelFutureListener.CLOSE));
    }
}

