/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.db;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoCollections;
import org.graylog2.database.PaginatedList;
import org.graylog2.database.entities.EntityScopeService;
import org.graylog2.database.pagination.MongoPaginationHelper;
import org.graylog2.database.utils.MongoUtils;
import org.graylog2.database.utils.ScopedEntityMongoUtils;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.lookup.dto.DataAdapterDto;
import org.graylog2.lookup.events.DataAdaptersDeleted;
import org.graylog2.lookup.events.DataAdaptersUpdated;

public class DBDataAdapterService {
    public static final String COLLECTION_NAME = "lut_data_adapters";
    private final ClusterEventBus clusterEventBus;
    private final MongoCollection<DataAdapterDto> collection;
    private final MongoUtils<DataAdapterDto> mongoUtils;
    private final ScopedEntityMongoUtils<DataAdapterDto> scopedEntityMongoUtils;
    private final MongoPaginationHelper<DataAdapterDto> paginationHelper;

    @Inject
    public DBDataAdapterService(MongoCollections mongoCollections, EntityScopeService entityScopeService, ClusterEventBus clusterEventBus) {
        this.clusterEventBus = clusterEventBus;
        this.collection = mongoCollections.collection(COLLECTION_NAME, DataAdapterDto.class);
        this.mongoUtils = mongoCollections.utils(this.collection);
        this.scopedEntityMongoUtils = mongoCollections.scopedEntityUtils(this.collection, entityScopeService);
        this.paginationHelper = mongoCollections.paginationHelper(this.collection);
        this.collection.createIndex(Indexes.ascending((String[])new String[]{"name"}), new IndexOptions().unique(true));
    }

    public Optional<DataAdapterDto> get(String idOrName) {
        if (ObjectId.isValid((String)idOrName)) {
            return this.mongoUtils.getById(idOrName);
        }
        return Optional.ofNullable((DataAdapterDto)this.collection.find(Filters.eq((String)"name", (Object)idOrName)).first());
    }

    public void forceSave(DataAdapterDto dataAdapter) {
        if (dataAdapter.id() == null) {
            this.collection.insertOne((Object)dataAdapter);
        } else {
            this.collection.replaceOne(MongoUtils.idEq(dataAdapter.id()), (Object)dataAdapter);
        }
    }

    public DataAdapterDto save(DataAdapterDto dataAdapter) {
        DataAdapterDto savedDataAdapter;
        if (dataAdapter.id() == null) {
            String id = this.scopedEntityMongoUtils.create(dataAdapter);
            savedDataAdapter = ((DataAdapterDto.Builder)dataAdapter.toBuilder().id(id)).build();
        } else {
            savedDataAdapter = this.scopedEntityMongoUtils.update(dataAdapter);
        }
        return savedDataAdapter;
    }

    public DataAdapterDto saveAndPostEvent(DataAdapterDto dataAdapter) {
        DataAdapterDto savedDataAdapter = this.save(dataAdapter);
        this.clusterEventBus.post(DataAdaptersUpdated.create(savedDataAdapter.id()));
        return savedDataAdapter;
    }

    public void postBulkUpdate(Set<String> updatedAdapterIds) {
        this.clusterEventBus.post(DataAdaptersUpdated.create(updatedAdapterIds));
    }

    public PaginatedList<DataAdapterDto> findPaginated(Bson query, Bson sort, int page, int perPage) {
        return this.paginationHelper.filter(query).sort(sort).perPage(perPage).page(page);
    }

    public void deleteAndPostEvent(String idOrName) {
        Optional<DataAdapterDto> dataAdapterDto = this.get(idOrName);
        dataAdapterDto.ifPresent(dataAdapter -> {
            this.scopedEntityMongoUtils.deleteById(dataAdapter.id());
            this.clusterEventBus.post(DataAdaptersDeleted.create(dataAdapter.id()));
        });
    }

    public void deleteAndPostEventImmutable(String idOrName) {
        Optional<DataAdapterDto> dataAdapterDto = this.get(idOrName);
        dataAdapterDto.ifPresent(dataAdapter -> {
            this.scopedEntityMongoUtils.forceDelete(dataAdapter.id());
            this.clusterEventBus.post(DataAdaptersDeleted.create(dataAdapter.id()));
        });
    }

    public Collection<DataAdapterDto> findByIds(Set<String> idSet) {
        return MongoUtils.stream(this.collection.find(MongoUtils.stringIdsIn(idSet))).toList();
    }

    public Collection<DataAdapterDto> findAll() {
        return MongoUtils.stream(this.collection.find()).toList();
    }
}

