/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import com.github.zafarkhaja.semver.Version;
import com.google.common.base.Strings;
import java.net.URL;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version
implements Comparable<Version> {
    private static final Logger LOG = LoggerFactory.getLogger(Version.class);
    private final com.github.zafarkhaja.semver.Version version;
    public static final Version CURRENT_CLASSPATH = Version.fromClasspathProperties(Version.from(0, 0, 0, "unknown"));

    @Deprecated
    public Version(int major, int minor, int patch) {
        this(Version.buildSemVer(major, minor, patch, null, null));
    }

    @Deprecated
    public Version(int major, int minor, int patch, String additional) {
        this(Version.buildSemVer(major, minor, patch, additional, null));
    }

    @Deprecated
    public Version(int major, int minor, int patch, String additional, String abbrevCommitSha) {
        this(Version.buildSemVer(major, minor, patch, additional, abbrevCommitSha));
    }

    public Version(com.github.zafarkhaja.semver.Version version) {
        this.version = Objects.requireNonNull(version);
    }

    public static Version from(int major, int minor, int patch) {
        return new Version(com.github.zafarkhaja.semver.Version.of((long)major, (long)minor, (long)patch));
    }

    public static Version from(int major, int minor, int patch, String preRelease) {
        return new Version(Version.buildSemVer(major, minor, patch, preRelease, null));
    }

    public static Version from(long major, long minor, long patch, String preRelease, String buildMetadata) {
        return new Version(Version.buildSemVer(major, minor, patch, preRelease, buildMetadata));
    }

    private static com.github.zafarkhaja.semver.Version buildSemVer(long major, long minor, long patch, String preRelease, String buildMetadata) {
        Version.Builder builder = new Version.Builder().setVersionCore(major, minor, patch);
        if (!Strings.isNullOrEmpty((String)preRelease)) {
            builder.setPreReleaseVersion(new String[]{preRelease});
        }
        if (!Strings.isNullOrEmpty((String)buildMetadata)) {
            builder.setBuildMetadata(new String[]{buildMetadata});
        }
        return builder.build();
    }

    public static Version fromPluginProperties(Class<?> pluginClass, String path, String propertyName, Version defaultVersion) {
        return Version.fromClasspathProperties(pluginClass, path, propertyName, null, null, defaultVersion);
    }

    public static Version fromPluginProperties(Class<?> pluginClass, String path, String propertyName, String gitPath, String gitPropertyName, Version defaultVersion) {
        return Version.fromClasspathProperties(pluginClass, path, propertyName, gitPath, gitPropertyName, defaultVersion);
    }

    public static Version fromClasspathProperties(Version defaultVersion) {
        return Version.fromClasspathProperties("version.properties", "project.version", "git.properties", "git.commit.id", defaultVersion);
    }

    public static Version fromClasspathProperties(String path, String gitPath, Version defaultVersion) {
        return Version.fromClasspathProperties(path, "project.version", gitPath, "git.commit.id", defaultVersion);
    }

    public static Version fromClasspathProperties(String path, String propertyName, String gitPath, String gitPropertyName, Version defaultVersion) {
        return Version.fromClasspathProperties(Version.class, path, propertyName, gitPath, gitPropertyName, defaultVersion);
    }

    public static Version fromClasspathProperties(@Nonnull Class<?> clazz, String path, String propertyName, String gitPath, String gitPropertyName, Version defaultVersion) {
        try {
            URL resource = Version.getResource(clazz, path);
            Properties versionProperties = new Properties();
            versionProperties.load(resource.openStream());
            com.github.zafarkhaja.semver.Version version = com.github.zafarkhaja.semver.Version.parse((String)versionProperties.getProperty(propertyName));
            long major = version.majorVersion();
            long minor = version.minorVersion();
            long patch = version.patchVersion();
            String qualifier = version.preReleaseVersion().orElse("");
            String buildMetadata = version.buildMetadata().orElse("");
            if (!Strings.isNullOrEmpty((String)buildMetadata)) {
                return Version.from(major, minor, patch, qualifier, buildMetadata);
            }
            String commitSha = null;
            try {
                Properties git = new Properties();
                URL gitResource = Version.getResource(clazz, gitPath);
                git.load(gitResource.openStream());
                commitSha = git.getProperty(gitPropertyName);
                if (commitSha != null && commitSha.length() > 7) {
                    commitSha = commitSha.substring(0, 7);
                }
            }
            catch (Exception e) {
                LOG.debug("Git commit details are not available, skipping.", (Throwable)e);
            }
            return Version.from(major, minor, patch, qualifier, commitSha);
        }
        catch (Exception e) {
            LOG.error("Unable to read " + path + ", this build has no version number. <{}>", (Object)e.toString());
            return defaultVersion;
        }
    }

    private static URL getResource(Class<?> clazz, String path) {
        URL url = Objects.requireNonNull(clazz, "Class argument is null!").getClassLoader().getResource(path);
        return Objects.requireNonNull(url, "Resource <" + path + "> not found.");
    }

    public com.github.zafarkhaja.semver.Version getVersion() {
        return this.version;
    }

    public String toString() {
        return this.version.toString();
    }

    public boolean sameOrHigher(Version other) {
        if (Strings.isNullOrEmpty((String)this.version.preReleaseVersion().orElse(""))) {
            return this.version.isHigherThanOrEquivalentTo(other.getVersion());
        }
        String version1 = this.version.toStableVersion().toString();
        com.github.zafarkhaja.semver.Version version2 = com.github.zafarkhaja.semver.Version.parse((String)version1);
        return version2.isHigherThanOrEquivalentTo(other.getVersion());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version that = (Version)o;
        return this.version.equals((Object)that.getVersion());
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    @Override
    public int compareTo(@Nonnull Version that) {
        Objects.requireNonNull(that);
        return this.version.compareTo(that.getVersion());
    }
}

