/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.models.tools.responses;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.util.List;
import javax.annotation.Nullable;
import org.graylog2.database.PaginatedList;
import org.graylog2.rest.models.SortOrder;
import org.graylog2.rest.models.tools.responses.AutoValue_PageListResponse;
import org.graylog2.rest.resources.entities.EntityAttribute;
import org.graylog2.rest.resources.entities.EntityDefaults;

@JsonAutoDetect
@AutoValue
public abstract class PageListResponse<T> {
    public static final String ELEMENTS_FIELD_NAME = "elements";
    public static final String TOTAL_FIELD_NAME = "total";
    public static final String QUERY_FIELD_NAME = "query";
    public static final String PAGINATION_FIELD_NAME = "pagination";
    public static final String SORT_FIELD_NAME = "sort";
    public static final String ORDER_FIELD_NAME = "order";
    public static final String ATTRIBUTES_FIELD_NAME = "attributes";
    public static final String DEFAULTS_FIELD_NAME = "defaults";

    @Nullable
    @JsonProperty(value="query")
    public abstract String query();

    @JsonProperty(value="pagination")
    public abstract PaginatedList.PaginationInfo paginationInfo();

    @JsonProperty(value="total")
    public abstract long total();

    @Nullable
    @JsonProperty(value="sort")
    public abstract String sort();

    @Nullable
    @JsonProperty(value="order")
    public abstract SortOrder order();

    @JsonProperty(value="elements")
    public abstract List<T> elements();

    @JsonProperty(value="attributes")
    public abstract List<EntityAttribute> attributes();

    @JsonProperty(value="defaults")
    public abstract EntityDefaults defaults();

    @JsonCreator
    public static <T> PageListResponse<T> create(@JsonProperty(value="query") @Nullable String query, @JsonProperty(value="pagination") PaginatedList.PaginationInfo paginationInfo, @JsonProperty(value="total") long total, @JsonProperty(value="sort") @Nullable String sort, @JsonProperty(value="order") @Nullable SortOrder order, @JsonProperty(value="elements") List<T> elements, @JsonProperty(value="attributes") List<EntityAttribute> attributes, @JsonProperty(value="defaults") EntityDefaults defaults) {
        return new AutoValue_PageListResponse<T>(query, paginationInfo, total, sort, order, elements, attributes, defaults);
    }

    public static <T> PageListResponse<T> create(@JsonProperty(value="query") @Nullable String query, @JsonProperty(value="pagination") PaginatedList.PaginationInfo paginationInfo, @JsonProperty(value="total") long total, @JsonProperty(value="sort") @Nullable String sort, @JsonProperty(value="order") @Nullable String order, @JsonProperty(value="elements") List<T> elements, @JsonProperty(value="attributes") List<EntityAttribute> attributes, @JsonProperty(value="defaults") EntityDefaults defaults) {
        return new AutoValue_PageListResponse<T>(query, paginationInfo, total, sort, order == null ? null : SortOrder.fromString(order), elements, attributes, defaults);
    }

    public static <T> PageListResponse<T> create(@Nullable String query, PaginatedList<T> paginatedList, @Nullable String sort, @Nullable String order, List<EntityAttribute> attributes, EntityDefaults defaults) {
        return new AutoValue_PageListResponse<T>(query, paginatedList.pagination(), paginatedList.pagination().total(), sort, order == null ? null : SortOrder.fromString(order), paginatedList, attributes, defaults);
    }
}

