/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.streams.destinations.filters;

import com.google.common.collect.ImmutableSet;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.core.Response;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderRegistry;
import org.graylog.plugins.pipelineprocessor.rulebuilder.db.RuleFragment;
import org.graylog.plugins.pipelineprocessor.rulebuilder.parser.RuleBuilderService;
import org.graylog.plugins.pipelineprocessor.rulebuilder.parser.validation.ValidatorService;
import org.graylog.plugins.pipelineprocessor.rulebuilder.rest.RuleBuilderDto;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Stream/Destinations/Filters/Builder", description="Stream destination filter builder", tags={"cloud"})
@Path(value="/streams/destinations/filters/builder")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RequiresAuthentication
public class StreamDestinationFilterBuilderResource
extends RestResource {
    private static final Set<String> INCLUDED_CONDITIONS = ImmutableSet.builder().add((Object)"array_contains").add((Object)"field_cidr").add((Object)"field_contains").add((Object)"field_ends_with").add((Object)"field_ip").add((Object)"field_not_null").add((Object)"field_null").add((Object)"field_starts_with").add((Object)"field_url").add((Object)"from_forwarder_input").add((Object)"from_input").add((Object)"grok_matches").add((Object)"has_field").add((Object)"has_field_equals").add((Object)"has_field_greater_or_equal").add((Object)"has_field_less_or_equal").add((Object)"lookup_has_value").add((Object)"lookup_string_list_contains").build();
    private final RuleBuilderRegistry ruleBuilderRegistry;
    private final ValidatorService validatorService;
    private final RuleBuilderService ruleBuilderService;

    @Inject
    public StreamDestinationFilterBuilderResource(RuleBuilderRegistry ruleBuilderRegistry, ValidatorService validatorService, RuleBuilderService ruleBuilderService) {
        this.ruleBuilderRegistry = ruleBuilderRegistry;
        this.validatorService = validatorService;
        this.ruleBuilderService = ruleBuilderService;
    }

    @GET
    @Path(value="/conditions")
    @ApiOperation(value="Get available filter rule conditions")
    @RequiresPermissions(value={"stream_destination_filters:read"})
    public Response getConditions() {
        List<FunctionDescriptor> conditions = this.ruleBuilderRegistry.conditions().values().stream().map(RuleFragment::descriptor).filter(descriptor -> INCLUDED_CONDITIONS.contains(descriptor.name())).sorted(Comparator.comparing(descriptor -> Objects.requireNonNullElse(descriptor.ruleBuilderName(), descriptor.name()))).toList();
        return Response.ok(Map.of("conditions", conditions)).build();
    }

    @POST
    @Path(value="/validate")
    @ApiOperation(value="Validate rule builder")
    @NoAuditEvent(value="No data changes. Only used to validate a rule builder.")
    public Response validateRule(@ApiParam(name="rule", required=true) @NotNull RuleBuilderDto ruleBuilderDto) {
        RuleBuilderDto validatedDto = this.validatorService.validate(ruleBuilderDto);
        RuleBuilderDto dtoWithTitles = validatedDto.toBuilder().ruleBuilder(this.ruleBuilderService.generateTitles(validatedDto.ruleBuilder())).build();
        return Response.ok(Map.of("rule_builder", dtoWithTitles)).build();
    }

    @POST
    @Path(value="/simulate")
    @ApiOperation(value="Run the simulator for the given rule and message")
    @NoAuditEvent(value="No data changes. Only used to simulate a filter rule.")
    @RequiresPermissions(value={"stream_destination_filters:read"})
    public Response simulateRule() {
        throw new ServerErrorException("Simulator not implemented yet", Response.Status.NOT_IMPLEMENTED);
    }
}

