/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.streams.destinations.filters;

import com.mongodb.client.model.Sorts;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.pipelineprocessor.rulebuilder.parser.validation.ValidatorService;
import org.graylog.plugins.pipelineprocessor.rulebuilder.rest.RuleBuilderDto;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.database.PaginatedList;
import org.graylog2.rest.PaginationParameters;
import org.graylog2.rest.models.PaginatedResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.utilities.StringUtils;
import org.graylog2.streams.StreamService;
import org.graylog2.streams.filters.StreamDestinationFilterRuleDTO;
import org.graylog2.streams.filters.StreamDestinationFilterService;

@Api(value="Stream/Destinations/Filters", description="Manage stream destination filter rules", tags={"cloud"})
@Path(value="/streams/{streamId}/destinations")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@RequiresAuthentication
public class StreamDestinationFiltersResource
extends RestResource {
    private final StreamDestinationFilterService filterService;
    private final StreamService streamService;
    private final ValidatorService validatorService;

    @Inject
    public StreamDestinationFiltersResource(StreamDestinationFilterService filterService, StreamService streamService, ValidatorService validatorService) {
        this.filterService = filterService;
        this.streamService = streamService;
        this.validatorService = validatorService;
    }

    @GET
    @Path(value="/filters")
    @ApiOperation(value="Get available filter rules for stream")
    public PaginatedResponse<StreamDestinationFilterRuleDTO> getPaginatedFiltersForStream(@ApiParam(name="streamId", required=true) @PathParam(value="streamId") @NotBlank String streamId, @ApiParam(name="pagination parameters") @BeanParam PaginationParameters paginationParams) {
        this.checkPermission("streams:edit", streamId);
        this.checkStream(streamId);
        PaginatedList<StreamDestinationFilterRuleDTO> paginatedList = this.filterService.findPaginatedForStream(streamId, paginationParams.getQuery(), Sorts.ascending((String[])new String[]{"title"}), paginationParams.getPerPage(), paginationParams.getPage(), dtoId -> this.isPermitted("stream_destination_filters:read", (String)dtoId));
        return PaginatedResponse.create("elements", paginatedList, paginationParams.getQuery());
    }

    @GET
    @Path(value="/target/{targetId}/filters")
    @ApiOperation(value="Get available filter rules for stream and target")
    public PaginatedResponse<StreamDestinationFilterRuleDTO> getPaginatedFiltersForStreamAndTarget(@ApiParam(name="streamId", required=true) @PathParam(value="streamId") @NotBlank String streamId, @ApiParam(name="targetId", required=true) @PathParam(value="targetId") @NotBlank String targetId, @ApiParam(name="pagination parameters") @BeanParam PaginationParameters paginationParams) {
        this.checkPermission("streams:edit", streamId);
        this.checkStream(streamId);
        PaginatedList<StreamDestinationFilterRuleDTO> paginatedList = this.filterService.findPaginatedForStreamAndTarget(streamId, targetId, paginationParams.getQuery(), Sorts.ascending((String[])new String[]{"title"}), paginationParams.getPerPage(), paginationParams.getPage(), dtoId -> this.isPermitted("stream_destination_filters:read", (String)dtoId));
        return PaginatedResponse.create("elements", paginatedList, paginationParams.getQuery());
    }

    @GET
    @Path(value="/filters/{filterId}")
    @ApiOperation(value="Get filter rule for given ID")
    public Response getFilter(@ApiParam(name="streamId", required=true) @PathParam(value="streamId") @NotBlank String streamId, @ApiParam(name="filterId", required=true) @PathParam(value="filterId") @NotBlank String filterId) {
        this.checkPermission("streams:edit", streamId);
        this.checkPermission("stream_destination_filters:read", filterId);
        this.checkStream(streamId);
        StreamDestinationFilterRuleDTO dto = this.filterService.findByIdForStream(streamId, filterId).orElseThrow(() -> new NotFoundException("Filter not found"));
        return Response.ok(this.wrapDto(dto)).build();
    }

    @POST
    @Path(value="/filters")
    @ApiOperation(value="Create new filter rule")
    @AuditEvent(type="server:stream_destination_filter:create")
    public Response createFilter(@ApiParam(name="streamId", required=true) @PathParam(value="streamId") @NotBlank String streamId, @ApiParam(name="JSON Body", required=true) @Valid StreamDestinationFilterRuleDTO dto) {
        this.checkPermission("streams:edit", streamId);
        this.checkPermission("stream_destination_filters:create");
        this.checkStream(streamId);
        this.validateDto(dto);
        try {
            return Response.ok(this.wrapDto(this.filterService.createForStream(streamId, dto))).build();
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    @PUT
    @Path(value="/filters/{filterId}")
    @ApiOperation(value="Update filter rule")
    @AuditEvent(type="server:stream_destination_filter:update")
    public Response updateFilter(@ApiParam(name="streamId", required=true) @PathParam(value="streamId") @NotBlank String streamId, @ApiParam(name="filterId", required=true) @PathParam(value="filterId") @NotBlank String filterId, @ApiParam(name="JSON Body", required=true) @Valid StreamDestinationFilterRuleDTO dto) {
        this.checkPermission("streams:edit", streamId);
        this.checkPermission("stream_destination_filters:edit", filterId);
        this.checkStream(streamId);
        if (!filterId.equals(dto.id())) {
            throw new BadRequestException("The filter ID in the URL doesn't match the one in the payload");
        }
        this.validateDto(dto);
        try {
            return Response.ok(this.wrapDto(this.filterService.updateForStream(streamId, dto))).build();
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    @DELETE
    @Path(value="/filters/{filterId}")
    @ApiOperation(value="Delete filter rule")
    @AuditEvent(type="server:stream_destination_filter:delete")
    public Response deleteFilter(@ApiParam(name="streamId", required=true) @PathParam(value="streamId") @NotBlank String streamId, @ApiParam(name="filterId", required=true) @PathParam(value="filterId") @NotBlank String filterId) {
        this.checkPermission("streams:edit", streamId);
        this.checkPermission("stream_destination_filters:delete", filterId);
        this.checkStream(streamId);
        try {
            return Response.ok(this.wrapDto(this.filterService.deleteFromStream(streamId, filterId))).build();
        }
        catch (IllegalArgumentException e) {
            throw new NotFoundException(e.getMessage());
        }
    }

    private Map<String, StreamDestinationFilterRuleDTO> wrapDto(StreamDestinationFilterRuleDTO dto) {
        return Map.of("filter", dto);
    }

    private void checkStream(String streamId) {
        try {
            this.streamService.load(streamId);
        }
        catch (org.graylog2.database.NotFoundException e) {
            throw new NotFoundException(StringUtils.f("Stream not found: %s", streamId));
        }
    }

    private void validateDto(@Valid StreamDestinationFilterRuleDTO dto) {
        RuleBuilderDto ruleBuilderDto = RuleBuilderDto.builder().title(dto.title()).ruleBuilder(dto.rule().toBuilder().actions(List.of()).build()).build();
        try {
            this.validatorService.validateAndFailFast(ruleBuilderDto);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage());
        }
    }
}

