/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.inputs;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.inputs.Input;
import org.graylog2.inputs.InputService;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.rest.models.system.inputs.requests.CreateStaticFieldRequest;
import org.graylog2.rest.resources.system.inputs.InputsResource;
import org.graylog2.shared.inputs.PersistedInputs;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="StaticFields", description="Static fields of an input")
@Path(value="/system/inputs/{inputId}/staticfields")
public class StaticFieldsResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(StaticFieldsResource.class);
    @Inject
    private InputService inputService;
    @Inject
    private ActivityWriter activityWriter;
    @Inject
    private PersistedInputs persistedInputs;

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add a static field to an input")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node."), @ApiResponse(code=400, message="Field/Key is reserved."), @ApiResponse(code=400, message="Missing or invalid configuration.")})
    @AuditEvent(type="server:static_field:create")
    public Response create(@ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId, @ApiParam(name="JSON body", required=true) @Valid @NotNull CreateStaticFieldRequest csfr) throws org.graylog2.database.NotFoundException, ValidationException {
        this.checkPermission("inputs:edit", inputId);
        MessageInput input = this.persistedInputs.get(inputId);
        if (input == null) {
            String msg = "Input <" + inputId + "> not found.";
            LOG.error(msg);
            throw new NotFoundException(msg);
        }
        if (!Message.validKey(csfr.key())) {
            String msg = "Invalid key: [" + csfr.key() + "]";
            LOG.error(msg);
            throw new BadRequestException(msg);
        }
        if (Message.RESERVED_FIELDS.contains((Object)csfr.key()) && !Message.RESERVED_SETTABLE_FIELDS.contains((Object)csfr.key())) {
            String message = "Cannot add static field. Field [" + csfr.key() + "] is reserved.";
            LOG.error(message);
            throw new BadRequestException(message);
        }
        input.addStaticField(csfr.key(), csfr.value());
        Input mongoInput = this.inputService.find(input.getPersistId());
        this.inputService.addStaticField(mongoInput, csfr.key(), csfr.value());
        String msg = "Added static field [" + csfr.key() + "] to input <" + inputId + ">.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, StaticFieldsResource.class));
        URI inputUri = this.getUriBuilderToSelf().path(InputsResource.class).path("{inputId}").build(new Object[]{mongoInput.getId()});
        return Response.created((URI)inputUri).build();
    }

    @DELETE
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Remove static field of an input")
    @ApiResponses(value={@ApiResponse(code=404, message="No such input on this node."), @ApiResponse(code=404, message="No such static field.")})
    @Path(value="/{key}")
    @AuditEvent(type="server:static_field:delete")
    public void delete(@ApiParam(name="Key", required=true) @PathParam(value="key") String key, @ApiParam(name="inputId", required=true) @PathParam(value="inputId") String inputId) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:edit", inputId);
        MessageInput input = this.persistedInputs.get(inputId);
        if (input == null) {
            String msg = "Input <" + inputId + "> not found.";
            LOG.error(msg);
            throw new NotFoundException(msg);
        }
        if (!input.getStaticFields().containsKey(key)) {
            String msg = "No such static field [" + key + "] on input <" + inputId + ">.";
            LOG.error(msg);
            throw new NotFoundException(msg);
        }
        input.getStaticFields().remove(key);
        Input mongoInput = this.inputService.find(input.getPersistId());
        this.inputService.removeStaticField(mongoInput, key);
        String msg = "Removed static field [" + key + "] of input <" + inputId + ">.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, StaticFieldsResource.class));
    }
}

