/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.tools;

import com.codahale.metrics.annotation.Timed;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.rest.models.tools.requests.RegexTestRequest;
import org.graylog2.rest.models.tools.responses.RegexTesterResponse;
import org.graylog2.rest.models.tools.responses.RegexValidationResponse;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Path(value="/tools/regex_tester")
public class RegexTesterResource
extends RestResource {
    @GET
    @Timed
    @Produces(value={"application/json"})
    public RegexTesterResponse regexTester(@QueryParam(value="regex") @NotEmpty String regex, @QueryParam(value="string") @NotNull String string) {
        return this.doTestRegex(string, regex);
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NoAuditEvent(value="only used to test regex values")
    public RegexTesterResponse testRegex(@Valid @NotNull RegexTestRequest regexTestRequest) {
        return this.doTestRegex(regexTestRequest.string(), regexTestRequest.regex());
    }

    @GET
    @Path(value="/validate")
    @Timed
    @Produces(value={"application/json"})
    public RegexValidationResponse validateRegex(@QueryParam(value="regex") @NotEmpty String regex) {
        RegexValidationResponse.Builder response = RegexValidationResponse.builder().regex(regex);
        try {
            Pattern.compile(regex, 32);
            response.isValid(true);
        }
        catch (PatternSyntaxException e) {
            response.isValid(false).validationMessage(e.getMessage());
        }
        return response.build();
    }

    private RegexTesterResponse doTestRegex(String example, String regex) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(regex, 32);
        }
        catch (PatternSyntaxException e) {
            throw new BadRequestException("Invalid regular expression: " + e.getMessage(), (Throwable)e);
        }
        Matcher matcher = pattern.matcher(example);
        boolean matched = matcher.find();
        RegexTesterResponse.Match match = matched && matcher.groupCount() > 0 ? RegexTesterResponse.Match.create(matcher.group(1), matcher.start(1), matcher.end(1)) : null;
        return RegexTesterResponse.create(matched, match, regex, example);
    }
}

