/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.plugins;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginProperties {
    private static final Logger LOG = LoggerFactory.getLogger(PluginProperties.class);
    private static final String MANIFEST_ATTRIBUTE = "Graylog-Plugin-Properties-Path";
    private static final String GRAYLOG_PLUGIN_PROPERTIES = "graylog-plugin.properties";
    private static final String PROPERTY_ISOLATED = "isolated";
    private static final String PROPERTY_ISOLATED_DEFAULT = "true";
    private final boolean isolated;

    public PluginProperties(Properties properties) {
        this.isolated = Boolean.parseBoolean((String)properties.getOrDefault((Object)PROPERTY_ISOLATED, PROPERTY_ISOLATED_DEFAULT));
    }

    public static PluginProperties fromJarFile(String filename) {
        Properties properties = new Properties();
        try {
            JarFile jarFile = new JarFile(Objects.requireNonNull(filename));
            Optional<String> propertiesPath = PluginProperties.getPropertiesPath(jarFile);
            if (propertiesPath.isPresent()) {
                LOG.debug("Loading <{}> from <{}>", (Object)propertiesPath.get(), (Object)filename);
                ZipEntry entry = jarFile.getEntry(propertiesPath.get());
                if (entry != null) {
                    properties.load(jarFile.getInputStream(entry));
                } else {
                    LOG.debug("Plugin properties <{}> are missing in <{}>", (Object)propertiesPath.get(), (Object)filename);
                }
            }
        }
        catch (Exception e) {
            LOG.debug("Unable to load properties from plugin <{}>", (Object)filename, (Object)e);
        }
        return new PluginProperties(properties);
    }

    private static Optional<String> getPropertiesPath(JarFile jarFile) throws IOException {
        String value = jarFile.getManifest().getMainAttributes().getValue(MANIFEST_ATTRIBUTE);
        if (Strings.isNullOrEmpty((String)value)) {
            LOG.debug("No value found for attribute <{}> in JAR manifest of file <{}>", (Object)MANIFEST_ATTRIBUTE, (Object)jarFile.getName());
            return Optional.empty();
        }
        return Optional.of(value + "/graylog-plugin.properties");
    }

    public boolean isIsolated() {
        return this.isolated;
    }
}

