/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import java.io.IOException;

public class EmbeddingControlFilter
implements ContainerResponseFilter {
    private static final String X_FRAME_OPTIONS = "X-Frame-Options";
    private final boolean httpAllowEmbedding;

    @Inject
    public EmbeddingControlFilter(@Named(value="http_allow_embedding") boolean httpAllowEmbedding) {
        this.httpAllowEmbedding = httpAllowEmbedding;
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        responseContext.getHeaders().add((Object)X_FRAME_OPTIONS, (Object)(this.httpAllowEmbedding ? EmbeddingOptions.SAMEORIGIN : EmbeddingOptions.DENY).toString());
    }

    static enum EmbeddingOptions {
        DENY,
        SAMEORIGIN;

    }
}

