/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security;

import jakarta.inject.Inject;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import java.lang.reflect.Method;
import org.graylog2.shared.security.RestrictToLeader;
import org.graylog2.shared.security.RestrictToLeaderFilter;
import org.graylog2.shared.security.RestrictToMaster;

public class RestrictToLeaderFeature
implements DynamicFeature {
    private final RestrictToLeaderFilter restrictToLeaderFilter;

    @Inject
    public RestrictToLeaderFeature(RestrictToLeaderFilter restrictToLeaderFilter) {
        this.restrictToLeaderFilter = restrictToLeaderFilter;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        Class resourceClass = resourceInfo.getResourceClass();
        Method resourceMethod = resourceInfo.getResourceMethod();
        if (resourceMethod.isAnnotationPresent(RestrictToLeader.class) || resourceMethod.isAnnotationPresent(RestrictToMaster.class) || resourceClass.isAnnotationPresent(RestrictToLeader.class) || resourceClass.isAnnotationPresent(RestrictToMaster.class)) {
            context.register((Object)this.restrictToLeaderFilter);
        }
    }
}

