/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.streams.filters;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Indexes;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoCollections;
import org.graylog2.database.PaginatedList;
import org.graylog2.database.pagination.MongoPaginationHelper;
import org.graylog2.database.utils.MongoUtils;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryParser;
import org.graylog2.shared.utilities.StringUtils;
import org.graylog2.streams.events.StreamDeletedEvent;
import org.graylog2.streams.filters.DestinationFilterCreationValidator;
import org.graylog2.streams.filters.StreamDestinationFilterDeletedEvent;
import org.graylog2.streams.filters.StreamDestinationFilterRuleDTO;
import org.graylog2.streams.filters.StreamDestinationFilterUpdatedEvent;
import org.mongojack.Id;

public class StreamDestinationFilterService {
    public static final String COLLECTION = "stream_destination_filters";
    private static final ImmutableMap<String, SearchQueryField> SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"title", (Object)SearchQueryField.create("title")).put((Object)"description", (Object)SearchQueryField.create("description")).put((Object)"destination_type", (Object)SearchQueryField.create("destination_type")).put((Object)"status", (Object)SearchQueryField.create("status")).build();
    private final MongoCollection<StreamDestinationFilterRuleDTO> collection;
    private final MongoPaginationHelper<StreamDestinationFilterRuleDTO> paginationHelper;
    private final MongoUtils<StreamDestinationFilterRuleDTO> utils;
    private final ClusterEventBus clusterEventBus;
    private final Optional<DestinationFilterCreationValidator> optionalDestinationFilterCreationValidator;

    @Inject
    public StreamDestinationFilterService(MongoCollections mongoCollections, ClusterEventBus clusterEventBus, EventBus eventBus, Optional<DestinationFilterCreationValidator> optionalDestinationFilterCreationValidator) {
        this.collection = mongoCollections.collection(COLLECTION, StreamDestinationFilterRuleDTO.class);
        this.paginationHelper = mongoCollections.paginationHelper(this.collection);
        this.utils = mongoCollections.utils(this.collection);
        this.clusterEventBus = clusterEventBus;
        this.optionalDestinationFilterCreationValidator = optionalDestinationFilterCreationValidator;
        this.collection.createIndex(Indexes.ascending((String[])new String[]{"stream_id"}));
        this.collection.createIndex(Indexes.ascending((String[])new String[]{"destination_type"}));
        this.collection.createIndex(Indexes.ascending((String[])new String[]{"status"}));
        eventBus.register((Object)this);
    }

    private Bson parseQuery(String queryString) {
        SearchQueryParser queryParser = new SearchQueryParser("title", (Map<String, SearchQueryField>)SEARCH_FIELD_MAPPING);
        return queryParser.parse(queryString).toBson();
    }

    public PaginatedList<StreamDestinationFilterRuleDTO> findPaginatedForStream(String streamId, String queryString, Bson sort, int perPage, int page, Predicate<String> permissionSelector) {
        Bson query = this.parseQuery(queryString);
        return this.paginationHelper.filter(Filters.and((Bson[])new Bson[]{Filters.eq((String)"stream_id", (Object)streamId), query})).sort(sort).perPage(perPage).page(page, dto -> permissionSelector.test(dto.id()));
    }

    public PaginatedList<StreamDestinationFilterRuleDTO> findPaginatedForStreamAndTarget(String streamId, String targetId, String queryString, Bson sort, int perPage, int page, Predicate<String> permissionSelector) {
        Bson query = this.parseQuery(queryString);
        return this.paginationHelper.filter(Filters.and((Bson[])new Bson[]{Filters.eq((String)"stream_id", (Object)streamId), Filters.eq((String)"destination_type", (Object)targetId), query})).sort(sort).perPage(perPage).page(page, dto -> permissionSelector.test(dto.id()));
    }

    public Optional<StreamDestinationFilterRuleDTO> findByIdForStream(String streamId, String id) {
        this.collection.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"stream_id", (Object)streamId), MongoUtils.idEq(id)}));
        return this.utils.getById(id);
    }

    public StreamDestinationFilterRuleDTO createForStream(String streamId, StreamDestinationFilterRuleDTO dto) {
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dto.id())) {
            throw new IllegalArgumentException("id must be blank");
        }
        this.optionalDestinationFilterCreationValidator.ifPresent(validator -> validator.validate(dto));
        ObjectId dtoId = MongoUtils.insertedId(this.collection.insertOne((Object)dto.withStream(streamId)));
        this.clusterEventBus.post(StreamDestinationFilterUpdatedEvent.of(dtoId.toHexString()));
        return this.utils.getById(dtoId).orElseThrow(() -> new IllegalArgumentException(StringUtils.f("Couldn't insert document: %s", dto)));
    }

    public StreamDestinationFilterRuleDTO updateForStream(String streamId, StreamDestinationFilterRuleDTO dto) {
        this.collection.replaceOne(Filters.and((Bson[])new Bson[]{Filters.eq((String)"stream_id", (Object)streamId), MongoUtils.idEq(StringUtils.requireNonBlank(dto.id(), "id can't be blank"))}), (Object)dto.withStream(streamId));
        this.clusterEventBus.post(StreamDestinationFilterUpdatedEvent.of(StringUtils.requireNonBlank(dto.id())));
        return this.utils.getById(dto.id()).orElseThrow(() -> new IllegalArgumentException(StringUtils.f("Couldn't find updated document: %s", dto)));
    }

    public StreamDestinationFilterRuleDTO deleteFromStream(String streamId, String id) {
        StreamDestinationFilterRuleDTO dto = this.utils.getById(id).orElseThrow(() -> new IllegalArgumentException(StringUtils.f("Couldn't find document with ID <%s> for deletion", id)));
        if (this.collection.deleteOne(Filters.and((Bson[])new Bson[]{Filters.eq((String)"stream_id", (Object)streamId), MongoUtils.idEq(id)})).getDeletedCount() > 0L) {
            this.clusterEventBus.post(StreamDestinationFilterDeletedEvent.of(id));
        }
        return dto;
    }

    public void forEachEnabledFilterGroupedByStream(Consumer<GroupByStreamResult> consumer) {
        this.collection.aggregate(List.of(Aggregates.match((Bson)Filters.eq((String)"status", (Object)((Object)StreamDestinationFilterRuleDTO.Status.ENABLED))), Aggregates.group((Object)"$stream_id", List.of(Accumulators.push((String)"filters", (Object)"$$ROOT")))), GroupByStreamResult.class).forEach(consumer);
    }

    @Subscribe
    public void handleStreamDeleted(StreamDeletedEvent streamDeletedEvent) {
        this.collection.deleteMany(Filters.eq((String)"stream_id", (Object)streamDeletedEvent.streamId()));
    }

    public record GroupByStreamResult(@JsonProperty(value="id") @Id String streamId, @JsonProperty(value="filters") Set<StreamDestinationFilterRuleDTO> filters) {
    }
}

