/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.telemetry.cluster;

import com.google.common.primitives.Ints;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.time.Duration;
import javax.annotation.Nonnull;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.telemetry.rest.TelemetryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelemetryClusterInfoPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(TelemetryClusterInfoPeriodical.class);
    private final Duration telemetryClusterInfoTtl;
    private final TelemetryService telemetryService;

    @Inject
    public TelemetryClusterInfoPeriodical(@Named(value="telemetry_cluster_info_ttl") Duration telemetryClusterInfoTtl, TelemetryService telemetryClusterService) {
        this.telemetryClusterInfoTtl = telemetryClusterInfoTtl;
        this.telemetryService = telemetryClusterService;
    }

    @Override
    public void doRun() {
        this.telemetryService.updateTelemetryClusterData();
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return Ints.saturatedCast((long)this.telemetryClusterInfoTtl.minusMinutes(1L).toSeconds());
    }

    @Override
    @Nonnull
    protected Logger getLogger() {
        return LOG;
    }
}

