/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.legacy;

import com.google.inject.Injector;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Set;
import org.graylog2.plugin.alarms.callbacks.AlarmCallback;
import org.graylog2.plugin.alarms.callbacks.AlarmCallbackConfigurationException;
import org.graylog2.plugin.configuration.Configuration;

public class LegacyAlarmCallbackFactory {
    private Injector injector;
    private final Set<Class<? extends AlarmCallback>> availableAlarmCallbacks;

    @Inject
    public LegacyAlarmCallbackFactory(Injector injector, Set<Class<? extends AlarmCallback>> availableAlarmCallbacks) {
        this.injector = injector;
        this.availableAlarmCallbacks = availableAlarmCallbacks;
    }

    public AlarmCallback create(String type, Map<String, Object> configuration) throws ClassNotFoundException, AlarmCallbackConfigurationException {
        AlarmCallback alarmCallback = this.create(type);
        alarmCallback.initialize(new Configuration(configuration));
        return alarmCallback;
    }

    private AlarmCallback create(String type) throws ClassNotFoundException {
        for (Class<? extends AlarmCallback> availableClass : this.availableAlarmCallbacks) {
            if (!availableClass.getCanonicalName().equals(type)) continue;
            return this.create(availableClass);
        }
        throw new RuntimeException("No class found for type " + type);
    }

    private AlarmCallback create(Class<? extends AlarmCallback> alarmCallbackClass) {
        return (AlarmCallback)this.injector.getInstance(alarmCallbackClass);
    }
}

