/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import javax.annotation.Nullable;
import org.graylog.events.contentpack.entities.EventNotificationConfigEntity;
import org.graylog.events.contentpack.entities.NotificationEntity;
import org.graylog.events.notifications.AutoValue_NotificationDto;
import org.graylog.events.notifications.EventNotificationConfig;
import org.graylog2.contentpacks.ContentPackable;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.database.MongoEntity;
import org.graylog2.plugin.rest.ValidationResult;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@JsonAutoDetect
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class NotificationDto
implements ContentPackable,
MongoEntity {
    public static final String FIELD_ID = "id";
    public static final String FIELD_TITLE = "title";
    public static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_CONFIG = "config";

    @Override
    @Id
    @ObjectId
    @Nullable
    @JsonProperty(value="id")
    public abstract String id();

    @JsonProperty(value="title")
    public abstract String title();

    @JsonProperty(value="description")
    public abstract String description();

    @JsonProperty(value="config")
    public abstract EventNotificationConfig config();

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @JsonIgnore
    public ValidationResult validate() {
        ValidationResult validation = new ValidationResult();
        if (this.title().isEmpty()) {
            validation.addError(FIELD_TITLE, "Notification title cannot be empty.");
        }
        try {
            validation.addAll(this.config().validate());
        }
        catch (UnsupportedOperationException e) {
            validation.addError(FIELD_CONFIG, "Notification config type cannot be empty.");
        }
        return validation;
    }

    public Object toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        EventNotificationConfigEntity config = (EventNotificationConfigEntity)this.config().toContentPackEntity(entityDescriptorIds);
        return NotificationEntity.builder().description(ValueReference.of(this.description())).title(ValueReference.of(this.title())).config(config).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_NotificationDto.Builder();
        }

        @Id
        @ObjectId
        @JsonProperty(value="id")
        public abstract Builder id(String var1);

        @JsonProperty(value="title")
        public abstract Builder title(String var1);

        @JsonProperty(value="description")
        public abstract Builder description(String var1);

        @JsonProperty(value="config")
        public abstract Builder config(EventNotificationConfig var1);

        public abstract NotificationDto build();
    }
}

