/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.grn;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.graylog.events.processor.EventDefinition;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNType;
import org.graylog.grn.GRNTypes;
import org.graylog2.plugin.database.users.User;

@Singleton
public class GRNRegistry {
    public static final GRN GLOBAL_USER_GRN = GRNTypes.BUILTIN_TEAM.newGRNBuilder().entity("everyone").build();
    private final ConcurrentMap<String, GRNType> REGISTRY = new ConcurrentHashMap<String, GRNType>();

    private GRNRegistry() {
    }

    public static GRNRegistry createEmpty() {
        return new GRNRegistry();
    }

    public static GRNRegistry createWithBuiltinTypes() {
        return GRNRegistry.createWithTypes(GRNTypes.builtinTypes());
    }

    public static GRNRegistry createWithTypes(Collection<GRNType> types) {
        GRNRegistry grnRegistry = new GRNRegistry();
        types.forEach(grnRegistry::registerType);
        return grnRegistry;
    }

    public GRN parse(String grnString) {
        return GRN.parse(grnString, this);
    }

    public GRN newGRN(String type, String entity) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)type) ? 1 : 0) != 0, (Object)"type cannot be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)entity) ? 1 : 0) != 0, (Object)"entity cannot be null or empty");
        return this.newGRNBuilder(type).entity(entity).build();
    }

    public GRN newGRN(GRNType type, String entity) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)entity) ? 1 : 0) != 0, (Object)"entity cannot be null or empty");
        return this.newGRNBuilder(type).entity(entity).build();
    }

    public GRN ofEventDefinition(EventDefinition eventDefinition) {
        return this.newGRN(GRNTypes.EVENT_DEFINITION, eventDefinition.id());
    }

    public GRN ofUser(User user) {
        return this.newGRN(GRNTypes.USER, user.getId());
    }

    public boolean isUser(GRN grn) {
        return grn.type().equals(GRNTypes.USER.type());
    }

    public GRN.Builder newGRNBuilder(String type) {
        GRNType grnType = Optional.ofNullable((GRNType)this.REGISTRY.get(this.toKey(type))).orElseThrow(() -> new IllegalArgumentException("type <" + type + "> does not exist"));
        return grnType.newGRNBuilder();
    }

    public GRN.Builder newGRNBuilder(GRNType type) {
        GRNType grnType = Optional.ofNullable((GRNType)this.REGISTRY.get(type.type())).orElseThrow(() -> new IllegalArgumentException("type <" + String.valueOf(type) + "> does not exist"));
        return grnType.newGRNBuilder();
    }

    public void registerType(GRNType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type cannot be null");
        if (this.REGISTRY.putIfAbsent(this.toKey(type.type()), type) != null) {
            throw new IllegalStateException("Type <" + type.type() + "> already exists");
        }
    }

    private String toKey(String type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type cannot be null");
        Preconditions.checkArgument((!type.trim().isEmpty() ? 1 : 0) != 0, (Object)"type name cannot be empty");
        return type.trim().toLowerCase(Locale.US);
    }
}

