/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.plugins.pipelineprocessor.ast.Rule;
import org.graylog.plugins.pipelineprocessor.ast.exceptions.FunctionEvaluationException;
import org.graylog.plugins.pipelineprocessor.ast.expressions.Expression;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog2.plugin.EmptyMessages;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.MessageCollection;
import org.graylog2.plugin.MessageFactory;
import org.graylog2.plugin.Messages;
import org.graylog2.shared.utilities.ExceptionUtils;
import org.graylog2.shared.utilities.StringUtils;

public class EvaluationContext {
    private static final EvaluationContext EMPTY_CONTEXT = new EvaluationContext(){

        @Override
        public void addCreatedMessage(Message newMessage) {
        }

        @Override
        public void define(String identifier, Class type, Object value) {
        }
    };
    @Nonnull
    private final Message message;
    @Nullable
    private Map<String, TypedValue> ruleVars;
    @Nullable
    private List<Message> createdMessages;
    @Nullable
    private List<EvalError> evalErrors;
    @Nullable
    private Rule currentRule;

    public void setRule(Rule rule) {
        this.currentRule = rule;
    }

    public Rule getRule() {
        return this.currentRule;
    }

    private EvaluationContext() {
        this(MessageFactory.createFakeMessage());
    }

    public EvaluationContext(@Nonnull Message message) {
        this.message = message;
    }

    public void define(String identifier, Class type, Object value) {
        if (this.ruleVars == null) {
            this.ruleVars = Maps.newHashMap();
        }
        this.ruleVars.put(identifier, new TypedValue(type, value));
    }

    public Message currentMessage() {
        return this.message;
    }

    public TypedValue get(String identifier) {
        if (this.ruleVars == null) {
            throw new IllegalStateException("Use of undeclared variable " + identifier);
        }
        return this.ruleVars.get(identifier);
    }

    public Messages createdMessages() {
        if (this.createdMessages == null) {
            return new EmptyMessages();
        }
        return new MessageCollection(this.createdMessages);
    }

    public void addCreatedMessage(Message newMessage) {
        if (this.createdMessages == null) {
            this.createdMessages = Lists.newArrayList();
        }
        this.createdMessages.add(newMessage);
    }

    public void clearCreatedMessages() {
        if (this.createdMessages != null) {
            this.createdMessages.clear();
        }
    }

    public static EvaluationContext emptyContext() {
        return EMPTY_CONTEXT;
    }

    public void addEvaluationError(int line, int charPositionInLine, @Nullable FunctionDescriptor descriptor, Throwable e) {
        if (this.evalErrors == null) {
            this.evalErrors = Lists.newArrayList();
        }
        this.evalErrors.add(new EvalError(line, charPositionInLine, descriptor, e));
    }

    public void onEvaluationException(Exception exception, Expression expression) {
        if (exception instanceof FunctionEvaluationException) {
            FunctionEvaluationException fee = (FunctionEvaluationException)exception;
            this.addEvaluationError(fee.getStartToken().getLine(), fee.getStartToken().getCharPositionInLine(), fee.getFunctionExpression().getFunction().descriptor(), ExceptionUtils.getRootCause(fee));
        } else {
            this.addEvaluationError(expression.getStartToken().getLine(), expression.getStartToken().getCharPositionInLine(), null, ExceptionUtils.getRootCause(exception));
        }
    }

    public boolean hasEvaluationErrors() {
        return this.evalErrors != null;
    }

    public List<EvalError> evaluationErrors() {
        return this.evalErrors == null ? Collections.emptyList() : Collections.unmodifiableList(this.evalErrors);
    }

    @Nullable
    public EvalError lastEvaluationError() {
        return this.evalErrors == null || this.evalErrors.isEmpty() ? null : this.evalErrors.get(this.evalErrors.size() - 1);
    }

    public String pipelineErrorMessage(String msg) {
        if (this.currentRule != null) {
            return StringUtils.f("Rule <%s> %s", this.currentRule.name(), msg);
        }
        return msg;
    }

    public static class TypedValue {
        private final Class type;
        private final Object value;

        public TypedValue(Class type, Object value) {
            this.type = type;
            this.value = value;
        }

        public Class getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static class EvalError {
        private final int line;
        private final int charPositionInLine;
        @Nullable
        private final FunctionDescriptor descriptor;
        private final Throwable throwable;

        public EvalError(int line, int charPositionInLine, @Nullable FunctionDescriptor descriptor, Throwable throwable) {
            this.line = line;
            this.charPositionInLine = charPositionInLine;
            this.descriptor = descriptor;
            this.throwable = throwable;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.descriptor != null) {
                sb.append("In call to function '").append(this.descriptor.name()).append("' at ");
            } else {
                sb.append("At ");
            }
            return sb.append(this.line).append(":").append(this.charPositionInLine).append(" an exception was thrown: ").append(this.throwable.getMessage()).toString();
        }
    }
}

