/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast;

import com.codahale.metrics.Meter;
import com.google.auto.value.AutoValue;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Token;
import org.graylog.plugins.pipelineprocessor.ast.AutoValue_Rule;
import org.graylog.plugins.pipelineprocessor.ast.expressions.BooleanExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.LogicalExpression;
import org.graylog.plugins.pipelineprocessor.ast.statements.Statement;
import org.graylog.plugins.pipelineprocessor.processors.PipelineInterpreter;
import org.graylog.plugins.pipelineprocessor.processors.PipelineMetricRegistry;

@AutoValue
public abstract class Rule {
    private static final RateLimitedLog LOG = PipelineInterpreter.getRateLimitedLog(Rule.class);
    private transient Meter globalExecuted;
    private transient Meter localExecuted;
    private transient Meter globalFailed;
    private transient Meter localFailed;
    private transient Meter globalMatched;
    private transient Meter localMatched;
    private transient Meter globalNotMatched;
    private transient Meter localNotMatched;

    @Nullable
    public abstract String id();

    public abstract String name();

    public abstract LogicalExpression when();

    public abstract Collection<Statement> then();

    public static Builder builder() {
        return new AutoValue_Rule.Builder();
    }

    public abstract Builder toBuilder();

    public Rule withId(String id) {
        return this.toBuilder().id(id).build();
    }

    public static Rule alwaysFalse(String name) {
        return Rule.builder().name(name).when(new BooleanExpression((Token)new CommonToken(-1), false)).then(Collections.emptyList()).build();
    }

    public void registerMetrics(PipelineMetricRegistry metricRegistry, String pipelineId, int stageId) {
        if (this.id() == null) {
            LOG.debug("Not registering metrics for unsaved rule {}", (Object)this.name());
            return;
        }
        this.globalExecuted = metricRegistry.registerGlobalRuleMeter(this.id(), "executed");
        this.localExecuted = metricRegistry.registerLocalRuleMeter(pipelineId, stageId, this.id(), "executed");
        this.globalFailed = metricRegistry.registerGlobalRuleMeter(this.id(), "failed");
        this.localFailed = metricRegistry.registerLocalRuleMeter(pipelineId, stageId, this.id(), "failed");
        this.globalMatched = metricRegistry.registerGlobalRuleMeter(this.id(), "matched");
        this.localMatched = metricRegistry.registerLocalRuleMeter(pipelineId, stageId, this.id(), "matched");
        this.globalNotMatched = metricRegistry.registerGlobalRuleMeter(this.id(), "not-matched");
        this.localNotMatched = metricRegistry.registerLocalRuleMeter(pipelineId, stageId, this.id(), "not-matched");
    }

    public void markExecution() {
        if (this.id() != null) {
            this.globalExecuted.mark();
            this.localExecuted.mark();
        }
    }

    public void markMatch() {
        if (this.id() != null) {
            this.globalMatched.mark();
            this.localMatched.mark();
        }
    }

    public void markNonMatch() {
        if (this.id() != null) {
            this.globalNotMatched.mark();
            this.localNotMatched.mark();
        }
    }

    public void markFailure() {
        if (this.id() != null) {
            this.globalFailed.mark();
            this.localFailed.mark();
        }
    }

    public Rule copy() {
        return this.toBuilder().build();
    }

    public String toString() {
        return "Rule '" + this.name() + "' (" + this.id() + ")";
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder name(String var1);

        public abstract Builder when(LogicalExpression var1);

        public abstract Builder then(Collection<Statement> var1);

        public abstract Rule build();
    }
}

