/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.strings;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.inject.TypeLiteral;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;

public class KeyValue
extends AbstractFunction<Map<String, String>> {
    public static final String NAME = "key_value";
    public static final String TAKE_FIRST = "take_first";
    public static final String TAKE_LAST = "take_last";
    public static final String ARRAY = "array";
    private final ParameterDescriptor<String, String> valueParam = ParameterDescriptor.string("value").ruleBuilderVariable().description("The string to extract key/value pairs from").build();
    private final ParameterDescriptor<String, CharMatcher> splitParam = ParameterDescriptor.string("delimiters", CharMatcher.class).transform(CharMatcher::anyOf).optional().description("The characters used to separate pairs, defaults to whitespace").build();
    private final ParameterDescriptor<String, CharMatcher> valueSplitParam = ParameterDescriptor.string("kv_delimiters", CharMatcher.class).transform(CharMatcher::anyOf).optional().description("The characters used to separate keys from values, defaults to '='").build();
    private final ParameterDescriptor<Boolean, Boolean> ignoreEmptyValuesParam = ParameterDescriptor.bool("ignore_empty_values").optional().description("Whether to ignore keys with empty values, defaults to true").defaultValue(Optional.of(true)).build();
    private final ParameterDescriptor<Boolean, Boolean> allowDupeKeysParam = ParameterDescriptor.bool("allow_dup_keys").optional().description("Whether to allow duplicate keys, defaults to true").defaultValue(Optional.of(true)).build();
    private final ParameterDescriptor<String, String> duplicateHandlingParam = ParameterDescriptor.string("handle_dup_keys").optional().defaultValue(Optional.of("take_first")).description("How to handle duplicate keys: (default) 'take_first': only use first value, 'take_last': only take last value or use a delimiter e.g. ','").build();
    private final ParameterDescriptor<String, CharMatcher> trimCharactersParam = ParameterDescriptor.string("trim_key_chars", CharMatcher.class).transform(CharMatcher::anyOf).optional().description("The characters to trim from keys, default is not to trim").build();
    private final ParameterDescriptor<String, CharMatcher> trimValueCharactersParam = ParameterDescriptor.string("trim_value_chars", CharMatcher.class).transform(CharMatcher::anyOf).optional().description("The characters to trim from values, default is not to trim").build();
    private final ParameterDescriptor<Boolean, Boolean> useEscapeCharacterParam = ParameterDescriptor.bool("use_escape_char").optional().description("Whether to make use of the escape character '\\' or treat it as a normal character, defaults to false treating '\\' as a normal character.").defaultValue(Optional.of(false)).build();

    @Override
    public Map<String, String> evaluate(FunctionArgs args, EvaluationContext context) {
        String value = this.valueParam.required(args, context);
        if (Strings.isNullOrEmpty((String)value)) {
            return Collections.emptyMap();
        }
        CharMatcher kvPairsMatcher = this.splitParam.optional(args, context).orElse(CharMatcher.whitespace());
        CharMatcher kvDelimMatcher = this.valueSplitParam.optional(args, context).orElse(CharMatcher.anyOf((CharSequence)"="));
        boolean allowEscaping = this.useEscapeCharacterParam.optional(args, context).orElse(false);
        Splitter outerSplitter = Splitter.on((CharMatcher)(allowEscaping ? DelimiterCharMatcher.withQuoteAndEscapeHandling(kvPairsMatcher) : DelimiterCharMatcher.withQuoteHandling(kvPairsMatcher))).omitEmptyStrings().trimResults();
        Splitter entrySplitter = Splitter.on((CharMatcher)kvDelimMatcher).omitEmptyStrings().limit(2).trimResults();
        return new MapSplitter(outerSplitter, entrySplitter, this.ignoreEmptyValuesParam.optional(args, context).orElse(true), this.trimCharactersParam.optional(args, context).orElse(CharMatcher.none()), this.trimValueCharactersParam.optional(args, context).orElse(CharMatcher.none()), this.allowDupeKeysParam.optional(args, context).orElse(true), this.duplicateHandlingParam.optional(args, context).orElse(TAKE_FIRST)).split(value);
    }

    @Override
    public FunctionDescriptor<Map<String, String>> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(new TypeLiteral<Map<String, String>>(){}.getRawType()).params(this.valueParam, this.splitParam, this.valueSplitParam, this.ignoreEmptyValuesParam, this.allowDupeKeysParam, this.duplicateHandlingParam, this.trimCharactersParam, this.trimValueCharactersParam, this.useEscapeCharacterParam).description("Extracts key/value pairs from a string").ruleBuilderEnabled().ruleBuilderName("Convert key/value to map").ruleBuilderTitle("Convert key/value string '${value}' to map").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.CONVERSION).build();
    }

    private static class DelimiterCharMatcher
    extends CharMatcher {
        private final char wrapperChar;
        private boolean inWrapper = false;

        static CharMatcher withQuoteHandling(CharMatcher charMatcher) {
            return new DelimiterCharMatcher('\"').and(new DelimiterCharMatcher('\'')).and(charMatcher);
        }

        static CharMatcher withQuoteAndEscapeHandling(CharMatcher charMatcher) {
            return new DelimiterCharMatcher('\"').and(new DelimiterCharMatcher('\'')).and((CharMatcher)new NotEscapedCharMatcher()).and(charMatcher);
        }

        private DelimiterCharMatcher(char wrapperChar) {
            this.wrapperChar = wrapperChar;
        }

        public boolean matches(char c) {
            if (this.wrapperChar == c) {
                this.inWrapper = !this.inWrapper;
            }
            return !this.inWrapper;
        }
    }

    private static class MapSplitter {
        private final Splitter outerSplitter;
        private final Splitter entrySplitter;
        private final boolean ignoreEmptyValues;
        private final CharMatcher keyTrimMatcher;
        private final CharMatcher valueTrimMatcher;
        private final Boolean allowDupeKeys;
        private final String duplicateHandling;

        MapSplitter(Splitter outerSplitter, Splitter entrySplitter, boolean ignoreEmptyValues, CharMatcher keyTrimMatcher, CharMatcher valueTrimMatcher, Boolean allowDupeKeys, String duplicateHandling) {
            this.outerSplitter = outerSplitter;
            this.entrySplitter = entrySplitter;
            this.ignoreEmptyValues = ignoreEmptyValues;
            this.keyTrimMatcher = keyTrimMatcher;
            this.valueTrimMatcher = valueTrimMatcher;
            this.allowDupeKeys = allowDupeKeys;
            this.duplicateHandling = duplicateHandling;
        }

        public Map<String, String> split(CharSequence sequence) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (String entry : this.outerSplitter.split(sequence)) {
                Iterator entryFields = this.entrySplitter.split((CharSequence)entry).iterator();
                if (!entryFields.hasNext()) continue;
                String key = this.processKey((String)entryFields.next());
                if (entryFields.hasNext()) {
                    String value = this.processValue((String)entryFields.next());
                    if (map.containsKey(key)) {
                        this.handleDuplicateKey(map, key, value);
                        continue;
                    }
                    this.handleKeyUpdate(map, key, value);
                    continue;
                }
                if (this.ignoreEmptyValues) continue;
                throw new IllegalArgumentException("Missing value for key " + key);
            }
            return map;
        }

        private void handleDuplicateKey(Map<String, String> map, String key, String value) {
            if (!this.allowDupeKeys.booleanValue()) {
                throw new IllegalArgumentException("Duplicate key " + key + " is not allowed in key_value function.");
            }
            switch (Strings.nullToEmpty((String)this.duplicateHandling).toLowerCase(Locale.ENGLISH)) {
                case "take_first": {
                    break;
                }
                case "take_last": {
                    this.handleKeyUpdate(map, key, value);
                    break;
                }
                default: {
                    this.concatDelimiter(map, key, value);
                }
            }
        }

        private String processKey(String key) {
            return this.keyTrimMatcher.trimFrom((CharSequence)key);
        }

        private String processValue(String value) {
            return this.valueTrimMatcher.trimFrom((CharSequence)value);
        }

        private void handleKeyUpdate(Map<String, String> map, String key, String value) {
            map.put(key, value);
        }

        private void concatDelimiter(Map<String, String> map, String key, String value) {
            String concatenatedValue = map.get(key) + this.duplicateHandling + value;
            map.put(key, concatenatedValue);
        }
    }

    private static class NotEscapedCharMatcher
    extends CharMatcher {
        private char lastChar = '\u0000';

        private NotEscapedCharMatcher() {
        }

        public boolean matches(char c) {
            if (this.lastChar == '\u0000') {
                this.lastChar = c;
                return true;
            }
            if (this.lastChar == '\\') {
                this.lastChar = c;
                return false;
            }
            this.lastChar = c;
            return true;
        }
    }
}

