/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.parser;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graylog.plugins.pipelineprocessor.ast.functions.Function;
import org.graylog.plugins.pipelineprocessor.parser.InternalPipelineFunctions;

public class FunctionRegistry {
    private final Map<String, Function<?>> functions;
    private final Map<String, Function<?>> internalFunctions;

    @Inject
    public FunctionRegistry(Map<String, Function<?>> functions, @InternalPipelineFunctions Map<String, Function<?>> internalFunctions) {
        this.functions = functions;
        this.internalFunctions = internalFunctions;
    }

    public FunctionRegistry(Map<String, Function<?>> functions) {
        this(functions, Map.of());
    }

    public Function<?> resolve(String name) {
        return this.functions.getOrDefault(name, this.internalFunctions.get(name));
    }

    public Function<?> resolveOrError(String name) {
        Function<?> function = this.resolve(name);
        if (function == null) {
            return Function.ERROR_FUNCTION;
        }
        return function;
    }

    public Collection<Function<?>> all() {
        return this.functions.values().stream().collect(Collectors.toList());
    }

    public Collection<Function<?>> allWithInternal() {
        return Stream.of(this.functions.values(), this.internalFunctions.values()).flatMap(Collection::stream).toList();
    }
}

