/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.services;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import jakarta.inject.Inject;
import jakarta.validation.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.bson.conversions.Bson;
import org.graylog.plugins.sidecar.rest.models.Collector;
import org.graylog.plugins.sidecar.rest.models.CollectorStatus;
import org.graylog.plugins.sidecar.rest.models.CollectorStatusList;
import org.graylog.plugins.sidecar.rest.models.Configuration;
import org.graylog.plugins.sidecar.rest.models.NodeDetails;
import org.graylog.plugins.sidecar.rest.models.Sidecar;
import org.graylog.plugins.sidecar.rest.models.SidecarSummary;
import org.graylog.plugins.sidecar.rest.requests.ConfigurationAssignment;
import org.graylog.plugins.sidecar.rest.requests.RegistrationRequest;
import org.graylog.plugins.sidecar.services.CollectorService;
import org.graylog.plugins.sidecar.services.ConfigurationService;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.PaginatedList;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.notifications.NotificationSystemEventPublisher;
import org.graylog2.search.SearchQuery;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;

public class SidecarService
extends PaginatedDbService<Sidecar> {
    private static final String COLLECTION_NAME = "sidecars";
    private final CollectorService collectorService;
    private final ConfigurationService configurationService;
    private final NotificationService notificationService;
    private final NotificationSystemEventPublisher notificationSystemEventPublisher;
    private final Validator validator;

    @Inject
    public SidecarService(CollectorService collectorService, ConfigurationService configurationService, MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, NotificationService notificationService, NotificationSystemEventPublisher notificationSystemEventPublisher, Validator validator) {
        super(mongoConnection, mapper, Sidecar.class, COLLECTION_NAME);
        this.collectorService = collectorService;
        this.configurationService = configurationService;
        this.notificationService = notificationService;
        this.notificationSystemEventPublisher = notificationSystemEventPublisher;
        this.validator = validator;
        this.db.createIndex((DBObject)new BasicDBObject("node_id", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
    }

    public long count() {
        return this.db.count();
    }

    @Override
    public Sidecar save(Sidecar sidecar) {
        Preconditions.checkNotNull((Object)sidecar, (Object)"sidecar was null");
        Set violations = this.validator.validate((Object)sidecar, new Class[0]);
        if (!violations.isEmpty()) {
            throw new IllegalArgumentException("Specified object failed validation: " + String.valueOf(violations));
        }
        return this.db.findAndModify((Bson)DBQuery.is((String)"node_id", (Object)sidecar.nodeId()), (Bson)new BasicDBObject(), (Bson)new BasicDBObject(), false, sidecar, true, true);
    }

    public Sidecar updateTaggedConfigurationAssignments(Sidecar sidecar) {
        Set<String> sidecarTags = sidecar.nodeDetails().tags();
        List<Configuration> taggedConfigs = this.configurationService.findByTags(sidecarTags);
        Set matchingOsCollectorIds = this.collectorService.all().stream().filter(c -> c.nodeOperatingSystem().equalsIgnoreCase(sidecar.nodeDetails().operatingSystem())).map(Collector::id).collect(Collectors.toSet());
        List<ConfigurationAssignment> tagAssigned = taggedConfigs.stream().filter(c -> matchingOsCollectorIds.contains(c.collectorId())).map(c -> {
            Set<String> matchedTags = c.tags().stream().filter(sidecarTags::contains).collect(Collectors.toSet());
            return ConfigurationAssignment.create(c.collectorId(), c.id(), matchedTags);
        }).toList();
        List<ConfigurationAssignment> manuallyAssigned = sidecar.assignments().stream().filter(a -> {
            if (tagAssigned.stream().anyMatch(tagAssignment -> tagAssignment.configurationId().equals(a.configurationId()))) {
                return false;
            }
            return a.assignedFromTags().isEmpty();
        }).toList();
        Collection union = CollectionUtils.union(manuallyAssigned, tagAssigned);
        return sidecar.toBuilder().assignments(new ArrayList<ConfigurationAssignment>(union)).build();
    }

    public List<Sidecar> all() {
        try (Stream collectorStream = this.streamAll();){
            List<Sidecar> list = collectorStream.collect(Collectors.toList());
            return list;
        }
    }

    public Sidecar findByNodeId(String id) {
        return (Sidecar)this.db.findOne((Bson)DBQuery.is((String)"node_id", (Object)id));
    }

    public PaginatedList<Sidecar> findPaginated(SearchQuery searchQuery, int page, int perPage, String sortField, String order) {
        DBQuery.Query dbQuery = searchQuery.toDBQuery();
        DBSort.SortBuilder sortBuilder = this.getSortBuilder(order, sortField);
        return this.findPaginatedWithQueryAndSort((Bson)dbQuery, (Bson)sortBuilder, page, perPage);
    }

    public PaginatedList<Sidecar> findPaginated(SearchQuery searchQuery, Predicate<Sidecar> filter, int page, int perPage, String sortField, String order) {
        DBQuery.Query dbQuery = searchQuery.toDBQuery();
        DBSort.SortBuilder sortBuilder = this.getSortBuilder(order, sortField);
        if (filter == null) {
            return this.findPaginatedWithQueryAndSort((Bson)dbQuery, (Bson)sortBuilder, page, perPage);
        }
        return this.findPaginatedWithQueryFilterAndSort((Bson)dbQuery, filter, (Bson)sortBuilder, page, perPage);
    }

    public int destroyExpired(Period period) {
        int count;
        DateTime threshold = DateTime.now((DateTimeZone)DateTimeZone.UTC).minus((ReadablePeriod)period);
        try (Stream collectorStream = this.streamAll();){
            count = collectorStream.mapToInt(collector -> {
                if (collector.lastSeen().isBefore((ReadableInstant)threshold)) {
                    return this.delete(collector.id());
                }
                return 0;
            }).sum();
        }
        return count;
    }

    public int markExpired(Period period, String message) {
        int count;
        DateTime threshold = DateTime.now((DateTimeZone)DateTimeZone.UTC).minus((ReadablePeriod)period);
        try (Stream collectorStream = this.streamAll();){
            count = collectorStream.mapToInt(collector -> {
                if (collector.nodeDetails().statusList() == null) {
                    return 0;
                }
                CollectorStatusList sidecarStatus = collector.nodeDetails().statusList();
                if (collector.lastSeen().isBefore((ReadableInstant)threshold) && Sidecar.Status.RUNNING.equals((Object)Sidecar.Status.fromStatusCode(sidecarStatus.status()))) {
                    NodeDetails nodeDetails = collector.nodeDetails();
                    ImmutableSet.Builder collectorStatuses = ImmutableSet.builder();
                    for (CollectorStatus collectorStatus : sidecarStatus.collectors()) {
                        collectorStatuses.add((Object)CollectorStatus.create(collectorStatus.collectorId(), Sidecar.Status.UNKNOWN.getStatusCode(), message, "", collectorStatus.configurationId()));
                    }
                    CollectorStatusList statusListToSave = CollectorStatusList.create(Sidecar.Status.UNKNOWN.getStatusCode(), message, (Set<CollectorStatus>)collectorStatuses.build());
                    NodeDetails nodeDetailsToSave = NodeDetails.create(nodeDetails.operatingSystem(), nodeDetails.ip(), nodeDetails.metrics(), nodeDetails.logFileList(), statusListToSave, nodeDetails.tags(), nodeDetails.collectorConfigurationDirectory());
                    Sidecar toSave = collector.toBuilder().nodeDetails(nodeDetailsToSave).build();
                    this.save(toSave);
                    this.createSystemNotification(message, toSave);
                    return 1;
                }
                return 0;
            }).sum();
        }
        return count;
    }

    private void createSystemNotification(String message, Sidecar toSave) {
        Notification notification = this.notificationService.buildNow();
        notification.addType(Notification.Type.SIDECAR_STATUS_UNKNOWN);
        notification.addSeverity(Notification.Severity.NORMAL);
        notification.addKey(toSave.nodeId());
        notification.addDetail("message", message);
        notification.addDetail("sidecar_name", toSave.nodeName());
        notification.addDetail("sidecar_id", toSave.nodeId());
        this.notificationSystemEventPublisher.submit(notification);
    }

    public Sidecar fromRequest(String nodeId, RegistrationRequest request, String collectorVersion) {
        return Sidecar.create(nodeId, request.nodeName(), NodeDetails.create(request.nodeDetails().operatingSystem(), request.nodeDetails().ip(), request.nodeDetails().metrics(), request.nodeDetails().logFileList(), request.nodeDetails().statusList(), request.nodeDetails().tags(), request.nodeDetails().collectorConfigurationDirectory()), collectorVersion);
    }

    public Sidecar applyManualAssignments(String sidecarNodeId, List<ConfigurationAssignment> assignments) throws NotFoundException {
        Sidecar sidecar = this.findByNodeId(sidecarNodeId);
        if (sidecar == null) {
            throw new NotFoundException("Couldn't find sidecar with nodeId " + sidecarNodeId);
        }
        for (ConfigurationAssignment assignment : assignments) {
            Collector collector = this.collectorService.find(assignment.collectorId());
            if (collector == null) {
                throw new NotFoundException("Couldn't find collector with ID " + assignment.collectorId());
            }
            Configuration configuration = this.configurationService.find(assignment.configurationId());
            if (configuration == null) {
                throw new NotFoundException("Couldn't find configuration with ID " + assignment.configurationId());
            }
            if (configuration.collectorId().equals(collector.id())) continue;
            throw new NotFoundException("Configuration doesn't match collector ID " + assignment.collectorId());
        }
        List<ConfigurationAssignment> taggedAssignments = sidecar.assignments().stream().filter(a -> !a.assignedFromTags().isEmpty()).toList();
        List<String> configIdsAssignedThroughTags = taggedAssignments.stream().map(ConfigurationAssignment::configurationId).toList();
        List<ConfigurationAssignment> filteredAssignments = assignments.stream().filter(a -> !configIdsAssignedThroughTags.contains(a.configurationId())).toList();
        Collection union = CollectionUtils.union(filteredAssignments, taggedAssignments);
        Sidecar toSave = sidecar.toBuilder().assignments(new ArrayList<ConfigurationAssignment>(union)).build();
        return this.save(toSave);
    }

    public List<SidecarSummary> toSummaryList(List<Sidecar> sidecars, Predicate<Sidecar> isActiveFunction) {
        return sidecars.stream().map(collector -> collector.toSummary(isActiveFunction)).collect(Collectors.toList());
    }

    public Stream<Sidecar> findByTagsAndOS(Collection<String> tags, String os) {
        return this.streamQuery((Bson)DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.in((String)"node_details.tags", tags), DBQuery.regex((String)"node_details.operating_system", (Pattern)Pattern.compile("^" + Pattern.quote(os) + "$", 2))}));
    }
}

