/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel.whois.ip;

import com.google.common.base.Strings;
import com.google.common.collect.ForwardingMap;
import java.util.HashMap;
import java.util.Map;

public class WhoisIpLookupResult
extends ForwardingMap<String, Object> {
    private static final String NA = "N/A";
    private static WhoisIpLookupResult EMPTY = new WhoisIpLookupResult("N/A", "N/A");
    private final String organization;
    private final String countryCode;
    private String prefix;

    WhoisIpLookupResult(String organization, String countryCode) {
        this.organization = organization;
        this.countryCode = countryCode;
    }

    static WhoisIpLookupResult empty() {
        return EMPTY;
    }

    public String getOrganization() {
        if (Strings.isNullOrEmpty((String)this.organization)) {
            return NA;
        }
        return this.organization;
    }

    public String getCountryCode() {
        if (Strings.isNullOrEmpty((String)this.countryCode)) {
            return NA;
        }
        return this.countryCode;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Map<String, Object> getResults() {
        StringBuilder keyOrg = new StringBuilder();
        StringBuilder keyCountryCode = new StringBuilder();
        if (this.prefix != null && !this.prefix.isEmpty()) {
            keyOrg.append(this.prefix).append("_");
            keyCountryCode.append(this.prefix).append("_");
        }
        keyOrg.append("whois_organization");
        keyCountryCode.append("whois_country_code");
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put(keyOrg.toString(), this.getOrganization());
        results.put(keyCountryCode.toString(), this.getCountryCode());
        return results;
    }

    protected Map<String, Object> delegate() {
        return this.getResults();
    }
}

