/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations;

import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Filters;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.bson.conversions.Bson;
import org.graylog.plugins.views.migrations.V20190127111728_MigrateWidgetFormatSettings;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20240626143000_CreateDashboardsView
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20190127111728_MigrateWidgetFormatSettings.class);
    private static final String DASHBOARDS_COLLECTION = "dashboards";
    private final ClusterConfigService clusterConfigService;
    private final MongoConnection mongoConnection;

    @Inject
    public V20240626143000_CreateDashboardsView(ClusterConfigService clusterConfigService, MongoConnection mongoConnection) {
        this.clusterConfigService = clusterConfigService;
        this.mongoConnection = mongoConnection;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2024-06-26T12:30:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed.");
            return;
        }
        MongoDatabase database = this.mongoConnection.getMongoDatabase();
        boolean collectionExists = ((ArrayList)database.listCollectionNames().into(new ArrayList())).contains(DASHBOARDS_COLLECTION);
        if (collectionExists) {
            database.getCollection(DASHBOARDS_COLLECTION).drop();
        }
        database.createView(DASHBOARDS_COLLECTION, "views", List.of(Aggregates.match((Bson)Filters.eq((String)"type", (Object)((Object)ViewDTO.Type.DASHBOARD)))));
        this.clusterConfigService.write(new MigrationCompleted(DateTime.now((DateTimeZone)DateTimeZone.UTC)));
    }

    record MigrationCompleted(DateTime completedAt) {
    }
}

