/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.engine.validation;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.engine.SearchConfig;
import org.graylog.plugins.views.search.engine.validation.SearchValidator;
import org.graylog.plugins.views.search.errors.QueryError;
import org.graylog.plugins.views.search.errors.SearchError;
import org.graylog.plugins.views.search.errors.SearchTypeError;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class TimeRangeValidator
implements SearchValidator {
    private final Provider<SearchConfig> searchConfigProvider;

    @Inject
    public TimeRangeValidator(Provider<SearchConfig> searchConfigProvider) {
        this.searchConfigProvider = searchConfigProvider;
    }

    private Stream<SearchError> validateQueryTimeRange(Query query, SearchConfig config) {
        Optional<SearchError> queryError = config.getQueryTimeRangeLimit().flatMap(timeRangeLimit -> Optional.ofNullable(query.timerange()).filter(tr -> tr.getFrom() != null && tr.getTo() != null).filter(tr -> this.isOutOfLimit((TimeRange)tr, (Period)timeRangeLimit))).map(tr -> new QueryError(query, "Search out of allowed time range limit", true));
        Stream searchTypeErrors = query.searchTypes().stream().flatMap(searchType -> this.validateSearchType(query, (SearchType)searchType, config).map(Stream::of).orElseGet(Stream::empty));
        return Stream.concat(queryError.map(Stream::of).orElseGet(Stream::empty), searchTypeErrors);
    }

    private Optional<SearchTypeError> validateSearchType(Query query, SearchType searchType, SearchConfig searchConfig) {
        return searchConfig.getQueryTimeRangeLimit().flatMap(configuredTimeLimit -> searchType.timerange().map(tr -> tr.effectiveTimeRange(query, searchType)).filter(tr -> this.isOutOfLimit((TimeRange)tr, (Period)configuredTimeLimit)).map(tr -> new SearchTypeError(query, searchType.id(), "Search type '" + searchType.type() + "' out of allowed time range limit", true)));
    }

    boolean isOutOfLimit(TimeRange timeRange, Period limit) {
        DateTime start = timeRange.getFrom();
        DateTime end = timeRange.getTo();
        DateTime allowedStart = end.minus((ReadablePeriod)limit);
        return start.isBefore((ReadableInstant)allowedStart);
    }

    @Override
    public Set<SearchError> validate(Search search, SearchUser searchUser) {
        SearchConfig searchConfig = (SearchConfig)this.searchConfigProvider.get();
        return search.queries().stream().flatMap(query -> this.validateQueryTimeRange((Query)query, searchConfig)).collect(Collectors.toSet());
    }

    @Override
    public Set<SearchError> validate(Query query, SearchUser searchUser) {
        SearchConfig searchConfig = (SearchConfig)this.searchConfigProvider.get();
        return this.validateQueryTimeRange(query, searchConfig).collect(Collectors.toSet());
    }
}

