/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.rest.QueryDTO;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

final class AutoValue_QueryDTO
extends QueryDTO {
    private final Optional<String> id;
    private final Optional<TimeRange> timerange;
    private final Optional<Filter> filter;
    private final List<UsedSearchFilter> filters;
    private final Optional<BackendQuery> query;
    private final Set<SearchType> searchTypes;

    private AutoValue_QueryDTO(Optional<String> id, Optional<TimeRange> timerange, Optional<Filter> filter, List<UsedSearchFilter> filters, Optional<BackendQuery> query, Set<SearchType> searchTypes) {
        this.id = id;
        this.timerange = timerange;
        this.filter = filter;
        this.filters = filters;
        this.query = query;
        this.searchTypes = searchTypes;
    }

    @Override
    @JsonProperty
    public Optional<String> id() {
        return this.id;
    }

    @Override
    @JsonProperty
    public Optional<TimeRange> timerange() {
        return this.timerange;
    }

    @Override
    @JsonProperty
    public Optional<Filter> filter() {
        return this.filter;
    }

    @Override
    @JsonProperty
    public List<UsedSearchFilter> filters() {
        return this.filters;
    }

    @Override
    @JsonProperty
    public Optional<BackendQuery> query() {
        return this.query;
    }

    @Override
    @JsonProperty(value="search_types")
    @Nonnull
    public Set<SearchType> searchTypes() {
        return this.searchTypes;
    }

    public String toString() {
        return "QueryDTO{id=" + String.valueOf(this.id) + ", timerange=" + String.valueOf(this.timerange) + ", filter=" + String.valueOf(this.filter) + ", filters=" + String.valueOf(this.filters) + ", query=" + String.valueOf(this.query) + ", searchTypes=" + String.valueOf(this.searchTypes) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof QueryDTO) {
            QueryDTO that = (QueryDTO)o;
            return this.id.equals(that.id()) && this.timerange.equals(that.timerange()) && this.filter.equals(that.filter()) && this.filters.equals(that.filters()) && this.query.equals(that.query()) && this.searchTypes.equals(that.searchTypes());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.timerange.hashCode();
        h$ *= 1000003;
        h$ ^= this.filter.hashCode();
        h$ *= 1000003;
        h$ ^= this.filters.hashCode();
        h$ *= 1000003;
        h$ ^= this.query.hashCode();
        h$ *= 1000003;
        return h$ ^= this.searchTypes.hashCode();
    }

    static final class Builder
    extends QueryDTO.Builder {
        private Optional<String> id = Optional.empty();
        private Optional<TimeRange> timerange = Optional.empty();
        private Optional<Filter> filter = Optional.empty();
        private List<UsedSearchFilter> filters;
        private Optional<BackendQuery> query = Optional.empty();
        private Set<SearchType> searchTypes;

        Builder() {
        }

        @Override
        public QueryDTO.Builder id(@Nullable String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        public QueryDTO.Builder timerange(@Nullable TimeRange timerange) {
            this.timerange = Optional.ofNullable(timerange);
            return this;
        }

        @Override
        public QueryDTO.Builder filter(@Nullable Filter filter) {
            this.filter = Optional.ofNullable(filter);
            return this;
        }

        @Override
        public QueryDTO.Builder filters(List<UsedSearchFilter> filters) {
            if (filters == null) {
                throw new NullPointerException("Null filters");
            }
            this.filters = filters;
            return this;
        }

        @Override
        public QueryDTO.Builder query(@Nullable BackendQuery query) {
            this.query = Optional.ofNullable(query);
            return this;
        }

        @Override
        public QueryDTO.Builder searchTypes(Set<SearchType> searchTypes) {
            if (searchTypes == null) {
                throw new NullPointerException("Null searchTypes");
            }
            this.searchTypes = searchTypes;
            return this;
        }

        @Override
        public QueryDTO build() {
            if (this.filters == null || this.searchTypes == null) {
                StringBuilder missing = new StringBuilder();
                if (this.filters == null) {
                    missing.append(" filters");
                }
                if (this.searchTypes == null) {
                    missing.append(" searchTypes");
                }
                throw new IllegalStateException("Missing required properties:" + String.valueOf(missing));
            }
            return new AutoValue_QueryDTO(this.id, this.timerange, this.filter, this.filters, this.query, this.searchTypes);
        }
    }
}

