/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.export.response;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import jakarta.inject.Inject;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.graylog.plugins.views.search.searchtypes.export.CSVWriter;
import org.graylog.plugins.views.search.searchtypes.export.ExportTabularResultResponse;
import org.graylog.plugins.views.search.searchtypes.export.XLSXWriter;

@Provider
@Produces(value={"text/csv", "application/json", "application/yaml", "application/xml", "application/vnd.ms-excel"})
public class AggregationWidgetExportResponseWriter
implements MessageBodyWriter<ExportTabularResultResponse> {
    private final ObjectMapper objectMapper;
    private final YAMLMapper yamlMapper;
    private final XmlMapper xmlMapper;

    @Inject
    public AggregationWidgetExportResponseWriter(ObjectMapper objectMapper, YAMLMapper yamlMapper, XmlMapper xmlMapper) {
        this.objectMapper = objectMapper;
        this.yamlMapper = yamlMapper;
        this.xmlMapper = xmlMapper;
    }

    public boolean isWriteable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return aClass.equals(ExportTabularResultResponse.class);
    }

    public void writeTo(ExportTabularResultResponse widgetExportResponse, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> multivaluedMap, OutputStream outputStream) throws IOException, WebApplicationException {
        switch (mediaType.toString()) {
            case "text/csv": {
                CSVWriter.writeCsv(widgetExportResponse, outputStream);
                break;
            }
            case "application/json": {
                this.objectMapper.writeValue(outputStream, (Object)widgetExportResponse);
                break;
            }
            case "application/yaml": {
                this.yamlMapper.writeValue(outputStream, (Object)widgetExportResponse);
                break;
            }
            case "application/xml": {
                this.xmlMapper.writeValue(outputStream, (Object)widgetExportResponse);
                break;
            }
            case "application/vnd.ms-excel": {
                XLSXWriter.writeXlsx(widgetExportResponse, outputStream);
                break;
            }
            default: {
                throw new IllegalArgumentException("Media type " + String.valueOf(mediaType) + " not supported");
            }
        }
    }
}

