/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.mapping;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.AggregationSpecToPivotMapper;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.MessagesSpecToMessageListMapper;
import org.graylog.plugins.views.search.rest.scriptingapi.request.AggregationRequestSpec;
import org.graylog.plugins.views.search.rest.scriptingapi.request.MessagesRequestSpec;
import org.graylog.plugins.views.search.rest.scriptingapi.request.SearchRequestSpec;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.streams.StreamService;

public class SearchRequestSpecToSearchMapper {
    public static final String QUERY_ID = "scripting_api_temporary_query";
    private final AggregationSpecToPivotMapper pivotCreator;
    private final MessagesSpecToMessageListMapper messageListCreator;
    private final Function<Collection<String>, Stream<String>> streamCategoryMapper;

    @Inject
    public SearchRequestSpecToSearchMapper(AggregationSpecToPivotMapper pivotCreator, MessagesSpecToMessageListMapper messageListCreator, StreamService streamService) {
        this.pivotCreator = pivotCreator;
        this.messageListCreator = messageListCreator;
        this.streamCategoryMapper = categories -> streamService.mapCategoriesToIds((Collection<String>)categories).stream();
    }

    public Search mapToSearch(MessagesRequestSpec messagesRequestSpec, SearchUser searchUser) {
        return this.mapToSearch(messagesRequestSpec, searchUser, this.messageListCreator);
    }

    public Search mapToSearch(AggregationRequestSpec aggregationRequestSpec, SearchUser searchUser) {
        return this.mapToSearch(aggregationRequestSpec, searchUser, this.pivotCreator);
    }

    private <T extends SearchRequestSpec> Search mapToSearch(T searchRequestSpec, SearchUser searchUser, Function<T, ? extends SearchType> searchTypeCreator) {
        Query query = Query.builder().id(QUERY_ID).searchTypes(Set.of(searchTypeCreator.apply(searchRequestSpec))).query(ElasticsearchQueryString.ofNullable(searchRequestSpec.queryString())).timerange(this.getTimerange(searchRequestSpec)).build();
        if (!searchRequestSpec.streams().isEmpty() || !searchRequestSpec.streamCategories().isEmpty()) {
            query = query.orStreamAndStreamCategoryFilters(new HashSet<String>(searchRequestSpec.streams()), new HashSet<String>(searchRequestSpec.streamCategories()));
        }
        return Search.builder().queries((ImmutableSet<Query>)ImmutableSet.of((Object)query)).build().addStreamsToQueriesWithCategories(this.streamCategoryMapper, searchUser).addStreamsToQueriesWithoutStreams(() -> searchUser.streams().readableOrAllIfEmpty(searchRequestSpec.streams()));
    }

    private TimeRange getTimerange(SearchRequestSpec searchRequestSpec) {
        return searchRequestSpec.timerange() != null ? searchRequestSpec.timerange() : RelativeRange.allTime();
    }
}

