/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.parsing;

import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.graylog.plugins.views.search.rest.scriptingapi.parsing.ShortTimerangeFormatParser;
import org.graylog2.plugin.indexer.searches.timeranges.KeywordRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

public class TimerangeParser {
    private final ShortTimerangeFormatParser shortTimerangeFormatParser;

    @Inject
    public TimerangeParser(ShortTimerangeFormatParser shortTimerangeFormatParser) {
        this.shortTimerangeFormatParser = shortTimerangeFormatParser;
    }

    public TimeRange parseTimeRange(String timerangeKeyword) {
        try {
            if (StringUtils.isBlank((String)timerangeKeyword)) {
                return null;
            }
            Optional<TimeRange> shortTimeRange = this.shortTimerangeFormatParser.parse(timerangeKeyword);
            return shortTimeRange.orElseGet(() -> KeywordRange.create(timerangeKeyword, "UTC"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse timerange " + timerangeKeyword + ". It should have a short format (i.e. '2h') or natural date format (i.e. 'last 2 hours')");
        }
    }
}

