/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.views;

import jakarta.inject.Inject;
import java.util.Map;
import java.util.Optional;
import org.graylog.plugins.views.Requirement;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchRequiresParameterSupport;
import org.graylog.plugins.views.search.db.SearchDbService;
import org.graylog.plugins.views.search.views.PluginMetadataSummary;
import org.graylog.plugins.views.search.views.ViewDTO;

public class RequiresParameterSupport
implements Requirement<ViewDTO> {
    private final SearchDbService searchDbService;
    private final SearchRequiresParameterSupport searchRequiresParameterSupport;

    @Inject
    public RequiresParameterSupport(SearchDbService searchDbService, SearchRequiresParameterSupport searchRequiresParameterSupport) {
        this.searchDbService = searchDbService;
        this.searchRequiresParameterSupport = searchRequiresParameterSupport;
    }

    @Override
    public Map<String, PluginMetadataSummary> test(ViewDTO view) {
        Optional<Search> optionalSearch = this.searchDbService.get(view.searchId());
        return optionalSearch.map(this.searchRequiresParameterSupport::test).orElseThrow(() -> new IllegalStateException("Search " + view.searchId() + " for view " + String.valueOf(view) + " is missing."));
    }
}

