/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler.schedule;

import com.cronutils.model.Cron;
import com.cronutils.model.time.ExecutionTime;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.graylog.scheduler.JobSchedule;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.graylog.scheduler.schedule.AutoValue_CronJobSchedule;
import org.graylog.scheduler.schedule.CronUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@JsonTypeName(value="cron")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class CronJobSchedule
implements JobSchedule {
    public static final String TYPE_NAME = "cron";
    public static final String FIELD_CRON_EXPRESSION = "cron_expression";
    public static final String FIELD_TIMEZONE = "timezone";
    public static final String DEFAULT_TIMEZONE = "UTC";

    @JsonProperty(value="cron_expression")
    public abstract String cronExpression();

    @JsonProperty(value="timezone")
    abstract Optional<String> timezone();

    @Override
    public Optional<DateTime> calculateNextTime(DateTime previousExecutionTime, DateTime lastNextTime, JobSchedulerClock clock) {
        Cron cron = CronUtils.getParser().parse(this.cronExpression());
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)cron);
        ZonedDateTime zdt = this.getZonedDateTime(lastNextTime == null ? clock.nowUTC() : lastNextTime);
        return executionTime.nextExecution(zdt).map(this::toDateTime);
    }

    private ZonedDateTime getZonedDateTime(DateTime dt) {
        Instant instant = Instant.ofEpochMilli(dt.getMillis());
        ZoneId zoneId = ZoneId.of(this.timezone().orElse(DEFAULT_TIMEZONE), ZoneId.SHORT_IDS);
        return ZonedDateTime.ofInstant(instant, zoneId);
    }

    private DateTime toDateTime(ZonedDateTime t) {
        DateTimeZone tz = DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(t.getZone()));
        return new DateTime(t.toInstant().toEpochMilli(), tz);
    }

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder
    implements JobSchedule.Builder<Builder> {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_CronJobSchedule.Builder().type(CronJobSchedule.TYPE_NAME);
        }

        @JsonProperty(value="cron_expression")
        public abstract Builder cronExpression(String var1);

        @JsonProperty(value="timezone")
        public abstract Builder timezone(@Nullable String var1);

        abstract CronJobSchedule autoBuild();

        public CronJobSchedule build() {
            this.type(CronJobSchedule.TYPE_NAME);
            CronJobSchedule schedule = this.autoBuild();
            CronUtils.validateExpression(schedule.cronExpression());
            return schedule;
        }
    }
}

