/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.shiro.subject.Subject;
import org.glassfish.hk2.api.Factory;
import org.glassfish.jersey.server.ContainerRequest;
import org.graylog.security.UserContext;
import org.graylog2.shared.security.ShiroSecurityContext;
import org.graylog2.shared.users.UserService;

public class UserContextFactory
implements Factory<UserContext> {
    @Context
    private Provider<ContainerRequest> containerRequestProvider;
    private final UserService userService;

    @Inject
    public UserContextFactory(UserService userService) {
        this.userService = userService;
    }

    public UserContext provide() {
        SecurityContext securityContext = ((ContainerRequest)this.containerRequestProvider.get()).getSecurityContext();
        if (securityContext instanceof ShiroSecurityContext) {
            ShiroSecurityContext context = (ShiroSecurityContext)securityContext;
            Subject subject = context.getSubject();
            return new UserContext.Factory(this.userService).create(subject);
        }
        throw new IllegalStateException("Failed to create UserContext");
    }

    public void dispose(UserContext instance) {
    }
}

