/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graylog.security.certutil.CertificateDto;
import org.graylog2.shared.utilities.StringUtils;

public record KeyStoreDto(@JsonPropertyOrder(alphabetic=true) Map<String, List<CertificateDto>> certificates) {
    public static KeyStoreDto empty() {
        return new KeyStoreDto(new HashMap<String, List<CertificateDto>>());
    }

    public static KeyStoreDto fromKeyStore(KeyStore keystore) throws KeyStoreException {
        HashMap<String, List<CertificateDto>> certificates = new HashMap<String, List<CertificateDto>>();
        Enumeration<String> aliases = keystore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate[] certificateChain = keystore.getCertificateChain(alias);
            if (certificateChain != null && certificateChain.length > 0) {
                List<CertificateDto> certs = Arrays.stream(certificateChain).filter(certificate -> certificate instanceof X509Certificate).map(certificate -> new CertificateDto((X509Certificate)certificate)).toList();
                certificates.put(alias, certs);
                continue;
            }
            Certificate certificate2 = keystore.getCertificate(alias);
            if (!(certificate2 instanceof X509Certificate)) continue;
            certificates.put(alias, List.of(new CertificateDto((X509Certificate)certificate2)));
        }
        return new KeyStoreDto(certificates);
    }

    public static KeyStoreDto fromCertificates(String prefix, Certificate[] certificates) {
        HashMap<String, List<CertificateDto>> certs = new HashMap<String, List<CertificateDto>>();
        for (int i = 0; i < certificates.length; ++i) {
            if (!(certificates[i] instanceof X509Certificate)) continue;
            certs.put(StringUtils.f(prefix + "[%03d]", i), List.of(new CertificateDto((X509Certificate)certificates[i])));
        }
        return new KeyStoreDto(certs);
    }

    public static KeyStoreDto fromSingleCertificate(String alias, X509Certificate certificate) {
        return new KeyStoreDto(Map.of(alias, List.of(new CertificateDto(certificate))));
    }
}

