/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.csr;

import jakarta.inject.Inject;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyStore;
import java.time.Duration;
import java.util.List;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.graylog.security.certutil.CaKeystore;
import org.graylog.security.certutil.CertRequest;
import org.graylog.security.certutil.CertificateGenerator;
import org.graylog.security.certutil.KeyPair;
import org.graylog.security.certutil.cert.CertificateChain;
import org.graylog.security.certutil.csr.ClientCert;
import org.graylog.security.certutil.csr.CsrGenerator;
import org.graylog.security.certutil.csr.InMemoryKeystoreInformation;
import org.graylog.security.certutil.csr.exceptions.ClientCertGenerationException;
import org.graylog2.cluster.certificates.CertificateSigningRequest;
import org.graylog2.indexer.security.SecurityAdapter;
import org.graylog2.plugin.certificates.RenewalPolicy;
import org.graylog2.plugin.cluster.ClusterConfigService;

public class ClientCertGenerator {
    private final CaKeystore caKeystore;
    private final ClusterConfigService clusterConfigService;
    private final SecurityAdapter securityAdapter;

    @Inject
    public ClientCertGenerator(CaKeystore caKeystore, ClusterConfigService clusterConfigService, SecurityAdapter securityAdapter) {
        this.caKeystore = caKeystore;
        this.clusterConfigService = clusterConfigService;
        this.securityAdapter = securityAdapter;
    }

    public ClientCert generateClientCert(String principal, String role, char[] privateKeyPassword) throws ClientCertGenerationException {
        try {
            RenewalPolicy renewalPolicy = this.clusterConfigService.get(RenewalPolicy.class);
            KeyPair keyPair = CertificateGenerator.generate(CertRequest.selfSigned(principal).isCA(false).validity(Duration.ofDays(3650L)));
            KeyStore keystore = keyPair.toKeystore("datanode", privateKeyPassword);
            InMemoryKeystoreInformation keystoreInformation = new InMemoryKeystoreInformation(keystore, privateKeyPassword);
            PKCS10CertificationRequest csr = CsrGenerator.generateCSR(keystoreInformation, "datanode", principal, List.of(principal));
            CertificateChain certChain = this.caKeystore.signCertificateRequest(new CertificateSigningRequest(principal, csr), renewalPolicy);
            this.securityAdapter.addUserToRoleMapping(role, principal);
            return new ClientCert(principal, role, this.serializeAsPEM(certChain.caCertificates().iterator().next()), this.serializeAsPEM(keyPair.privateKey()), this.serializeAsPEM(certChain.signedCertificate()));
        }
        catch (Exception e) {
            throw new ClientCertGenerationException("Failed to generate client certificate: " + e.getMessage(), e);
        }
    }

    public void removeCertFor(String role, String principal) throws IOException {
        this.securityAdapter.removeUserFromRoleMapping(role, principal);
    }

    private String serializeAsPEM(Object o) throws IOException {
        StringWriter writer = new StringWriter();
        try (JcaPEMWriter jcaPEMWriter = new JcaPEMWriter((Writer)writer);){
            jcaPEMWriter.writeObject(o);
        }
        return writer.toString();
    }
}

