/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.csr.storage;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.graylog.security.certutil.csr.storage.CsrStorage;

public record CsrFileStorage(String csrFilename) implements CsrStorage
{
    @Override
    public void writeCsr(PKCS10CertificationRequest csr) throws IOException {
        try (JcaPEMWriter jcaPEMWriter = new JcaPEMWriter((Writer)new FileWriter(this.csrFilename, Charset.defaultCharset()));){
            jcaPEMWriter.writeObject((Object)csr);
        }
    }

    @Override
    public PKCS10CertificationRequest readCsr() throws IOException {
        BufferedReader pemReader = new BufferedReader(new FileReader(this.csrFilename, Charset.defaultCharset()));
        PEMParser pemParser = new PEMParser((Reader)pemReader);
        Object parsedObj = pemParser.readObject();
        if (parsedObj instanceof PKCS10CertificationRequest) {
            return (PKCS10CertificationRequest)parsedObj;
        }
        return null;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

