/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.keystore.storage;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Optional;
import org.graylog.security.certutil.ca.exceptions.KeyStoreStorageException;
import org.graylog.security.certutil.keystore.storage.KeystoreStorage;
import org.graylog.security.certutil.keystore.storage.KeystoreUtils;

public final class KeystoreFileStorage
implements KeystoreStorage<Path> {
    @Override
    public void writeKeyStore(Path location, KeyStore keyStore, char[] currentPassword, char[] newPassword) throws KeyStoreStorageException {
        try (FileOutputStream store = new FileOutputStream(location.toFile());){
            if (newPassword == null) {
                keyStore.store(store, currentPassword);
            } else {
                KeyStore newKeyStore = KeystoreUtils.newStoreCopyContent(keyStore, currentPassword, newPassword);
                newKeyStore.store(store, newPassword);
            }
        }
        catch (Exception ex) {
            throw new KeyStoreStorageException("Failed to save keystore to " + String.valueOf(location), ex);
        }
    }

    @Override
    public Optional<KeyStore> readKeyStore(Path location, char[] password) throws KeyStoreStorageException {
        Optional<KeyStore> optional;
        block8: {
            InputStream in = Files.newInputStream(location, new OpenOption[0]);
            try {
                KeyStore caKeystore = KeyStore.getInstance("PKCS12");
                caKeystore.load(in, password);
                optional = Optional.of(caKeystore);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | GeneralSecurityException ex) {
                    throw new KeyStoreStorageException("Could not read keystore: " + ex.getMessage(), ex);
                }
            }
            in.close();
        }
        return optional;
    }
}

