/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings.providers;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.graylog2.database.NotFoundException;
import org.graylog2.gelfclient.util.Uninterruptibles;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultStreamProvider
implements Provider<Stream> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStreamProvider.class);
    private final StreamService service;
    private AtomicReference<Stream> sharedInstance = new AtomicReference();

    @Inject
    private DefaultStreamProvider(StreamService service) {
        this.service = service;
    }

    public void setDefaultStream(Stream defaultStream) {
        LOG.debug("Setting new default stream: {}", (Object)defaultStream);
        this.sharedInstance.set(defaultStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream get() {
        Stream defaultStream = this.sharedInstance.get();
        if (defaultStream != null) {
            return defaultStream;
        }
        DefaultStreamProvider defaultStreamProvider = this;
        synchronized (defaultStreamProvider) {
            defaultStream = this.sharedInstance.get();
            if (defaultStream != null) {
                return defaultStream;
            }
            int i = 0;
            do {
                try {
                    LOG.debug("Loading shared default stream instance");
                    defaultStream = this.service.load("000000000000000000000001");
                }
                catch (NotFoundException ignored) {
                    if (i % 10 == 0) {
                        LOG.warn("Unable to load default stream, tried {} times, retrying every 500ms. Processing is blocked until this succeeds.", (Object)(i + 1));
                    }
                    ++i;
                    Uninterruptibles.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
            } while (defaultStream == null);
            this.sharedInstance.set(defaultStream);
        }
        return defaultStream;
    }
}

