/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight.web.resources;

import com.google.common.base.MoreObjects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.Resources;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.activation.MimetypesFileTypeMap;
import javax.annotation.Nonnull;
import org.apache.shiro.authz.annotation.RequiresPermissions;

@Path(value="/")
public class PreflightAssetsResource {
    private final MimetypesFileTypeMap mimeTypes;
    private final LoadingCache<URI, FileSystem> fileSystemCache;

    @Inject
    public PreflightAssetsResource(MimetypesFileTypeMap mimeTypes) {
        this.mimeTypes = mimeTypes;
        this.fileSystemCache = CacheBuilder.newBuilder().maximumSize(1024L).build((CacheLoader)new CacheLoader<URI, FileSystem>(){

            public FileSystem load(@Nonnull URI key) throws Exception {
                try {
                    return FileSystems.getFileSystem(key);
                }
                catch (FileSystemNotFoundException e) {
                    try {
                        return FileSystems.newFileSystem(key, Collections.emptyMap());
                    }
                    catch (FileSystemAlreadyExistsException f) {
                        return FileSystems.getFileSystem(key);
                    }
                }
            }
        });
    }

    @Produces(value={"text/html"})
    @GET
    @RequiresPermissions(value={"preflight:only"})
    public Response index(@Context Request request) {
        return this.get(request, "index.html");
    }

    @Path(value="/{filename}")
    @GET
    @RequiresPermissions(value={"preflight:only"})
    public Response get(@Context Request request, @PathParam(value="filename") String filename) {
        try {
            URL resourceUrl = this.getResourceUri(filename);
            return this.getResponse(request, filename, resourceUrl);
        }
        catch (IOException | URISyntaxException e) {
            throw new NotFoundException("Couldn't find " + filename, (Throwable)e);
        }
    }

    private URL getResourceUri(String filename) throws FileNotFoundException {
        URL resourceUrl = this.getClass().getResource("/preflight/assets/" + filename);
        if (resourceUrl == null) {
            throw new FileNotFoundException("Resource file " + filename + " not found.");
        }
        return resourceUrl;
    }

    private Response getResponse(Request request, String filename, URL resourceUrl) throws IOException, URISyntaxException {
        java.nio.file.Path path;
        URI uri = resourceUrl.toURI();
        byte[] fileContents = switch (resourceUrl.getProtocol()) {
            case "file" -> {
                path = Paths.get(uri);
                yield Files.readAllBytes(path);
            }
            case "jar" -> {
                FileSystem fileSystem = (FileSystem)this.fileSystemCache.getUnchecked((Object)uri);
                path = fileSystem.getPath("/preflight/assets/" + filename, new String[0]);
                yield Resources.toByteArray((URL)resourceUrl);
            }
            default -> throw new IllegalArgumentException("Not a JAR or local file: " + String.valueOf(resourceUrl));
        };
        FileTime lastModifiedTime = Files.getLastModifiedTime(path, new LinkOption[0]);
        Date lastModified = Date.from(lastModifiedTime.toInstant());
        HashCode hashCode = Hashing.sha256().hashBytes(fileContents);
        EntityTag entityTag = new EntityTag(hashCode.toString());
        Response.ResponseBuilder response = request.evaluatePreconditions(lastModified, entityTag);
        if (response != null) {
            return response.build();
        }
        String contentType = (String)MoreObjects.firstNonNull((Object)this.mimeTypes.getContentType(filename), (Object)"application/octet-stream");
        CacheControl cacheControl = new CacheControl();
        cacheControl.setMaxAge((int)TimeUnit.DAYS.toSeconds(365L));
        cacheControl.setNoCache(false);
        cacheControl.setPrivate(false);
        return Response.ok((Object)fileContents, (String)contentType).tag(entityTag).cacheControl(cacheControl).lastModified(lastModified).build();
    }
}

