/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.buffers;

import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import jakarta.inject.Inject;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.graylog2.buffers.OutputBuffer;
import org.graylog2.plugin.buffers.EventBuffer;
import org.graylog2.plugin.buffers.InputBuffer;
import org.graylog2.shared.buffers.ProcessBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Buffers {
    private static final Logger LOG = LoggerFactory.getLogger(Buffers.class);
    private static final long DEFAULT_MAX_WAIT = 30L;
    private final InputBuffer inputBuffer;
    private final ProcessBuffer processBuffer;
    private final OutputBuffer outputBuffer;

    @Inject
    public Buffers(InputBuffer inputBuffer, ProcessBuffer processBuffer, OutputBuffer outputBuffer) {
        this.inputBuffer = inputBuffer;
        this.processBuffer = processBuffer;
        this.outputBuffer = outputBuffer;
    }

    @Deprecated
    public void waitForEmptyBuffers() {
        this.waitForEmptyBuffers(EnumSet.of(Type.PROCESS, Type.OUTPUT));
    }

    public void waitForEmptyBuffers(EnumSet<Type> bufferTypes) {
        this.waitForEmptyBuffers(bufferTypes, 30L, TimeUnit.SECONDS);
    }

    @Deprecated
    public void waitForEmptyBuffers(long maxWait, TimeUnit timeUnit) {
        this.waitForEmptyBuffers(EnumSet.of(Type.PROCESS, Type.OUTPUT), maxWait, timeUnit);
    }

    public void waitForEmptyBuffers(EnumSet<Type> bufferTypes, long maxWait, TimeUnit timeUnit) {
        if (bufferTypes.isEmpty()) {
            return;
        }
        LOG.info("Waiting until {} buffers are empty.", bufferTypes);
        Map<Type, EventBuffer> buffersByTypes = this.buffersByTypes(bufferTypes);
        Retryer retryer = RetryerBuilder.newBuilder().retryIfResult(Predicates.not((Predicate)Predicates.equalTo((Object)Boolean.TRUE))).withWaitStrategy(WaitStrategies.fixedWait((long)1L, (TimeUnit)TimeUnit.SECONDS)).withStopStrategy(StopStrategies.stopAfterDelay((long)maxWait, (TimeUnit)timeUnit)).build();
        try {
            retryer.call(() -> {
                if (buffersByTypes.values().stream().allMatch(EventBuffer::isEmpty)) {
                    return true;
                }
                LOG.info("Waiting for buffers to drain. ({})", (Object)this.getUsageStats(buffersByTypes));
                return false;
            });
        }
        catch (RetryException e) {
            LOG.info("Buffers not empty after {} {}. Giving up.", (Object)maxWait, (Object)timeUnit.name().toLowerCase(Locale.ENGLISH));
            return;
        }
        catch (ExecutionException e) {
            LOG.error("Error while waiting for empty buffers.", (Throwable)e);
            return;
        }
        LOG.info("All buffers are empty. Continuing.");
    }

    private String getUsageStats(Map<Type, EventBuffer> buffersByTypes) {
        return buffersByTypes.entrySet().stream().map(e -> ((EventBuffer)e.getValue()).getUsage() + ((Type)((Object)((Object)e.getKey()))).name().substring(0, 1).toLowerCase(Locale.ENGLISH)).collect(Collectors.joining("/"));
    }

    private Map<Type, EventBuffer> buffersByTypes(EnumSet<Type> bufferTypes) {
        LinkedHashMap<Type, EventBuffer> bufferMap = new LinkedHashMap<Type, EventBuffer>();
        if (bufferTypes.contains((Object)Type.INPUT)) {
            bufferMap.put(Type.INPUT, this.inputBuffer);
        }
        if (bufferTypes.contains((Object)Type.PROCESS)) {
            bufferMap.put(Type.PROCESS, this.processBuffer);
        }
        if (bufferTypes.contains((Object)Type.OUTPUT)) {
            bufferMap.put(Type.OUTPUT, this.outputBuffer);
        }
        return bufferMap;
    }

    public static enum Type {
        INPUT,
        PROCESS,
        OUTPUT;

    }
}

