/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.cluster.lock;

import java.time.ZonedDateTime;
import org.graylog2.cluster.lock.Lock;

final class AutoValue_Lock
extends Lock {
    private final String resource;
    private final String lockedBy;
    private final ZonedDateTime createdAt;
    private final ZonedDateTime updatedAt;

    private AutoValue_Lock(String resource, String lockedBy, ZonedDateTime createdAt, ZonedDateTime updatedAt) {
        this.resource = resource;
        this.lockedBy = lockedBy;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    @Override
    public String resource() {
        return this.resource;
    }

    @Override
    public String lockedBy() {
        return this.lockedBy;
    }

    @Override
    public ZonedDateTime createdAt() {
        return this.createdAt;
    }

    @Override
    public ZonedDateTime updatedAt() {
        return this.updatedAt;
    }

    public String toString() {
        return "Lock{resource=" + this.resource + ", lockedBy=" + this.lockedBy + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Lock) {
            Lock that = (Lock)o;
            return this.resource.equals(that.resource()) && this.lockedBy.equals(that.lockedBy()) && this.createdAt.equals(that.createdAt()) && this.updatedAt.equals(that.updatedAt());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.resource.hashCode();
        h$ *= 1000003;
        h$ ^= this.lockedBy.hashCode();
        h$ *= 1000003;
        h$ ^= this.createdAt.hashCode();
        h$ *= 1000003;
        return h$ ^= this.updatedAt.hashCode();
    }

    static final class Builder
    extends Lock.Builder {
        private String resource;
        private String lockedBy;
        private ZonedDateTime createdAt;
        private ZonedDateTime updatedAt;

        Builder() {
        }

        @Override
        public Lock.Builder resource(String resource) {
            if (resource == null) {
                throw new NullPointerException("Null resource");
            }
            this.resource = resource;
            return this;
        }

        @Override
        public Lock.Builder lockedBy(String lockedBy) {
            if (lockedBy == null) {
                throw new NullPointerException("Null lockedBy");
            }
            this.lockedBy = lockedBy;
            return this;
        }

        @Override
        public Lock.Builder createdAt(ZonedDateTime createdAt) {
            if (createdAt == null) {
                throw new NullPointerException("Null createdAt");
            }
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public Lock.Builder updatedAt(ZonedDateTime updatedAt) {
            if (updatedAt == null) {
                throw new NullPointerException("Null updatedAt");
            }
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public Lock build() {
            if (this.resource == null || this.lockedBy == null || this.createdAt == null || this.updatedAt == null) {
                StringBuilder missing = new StringBuilder();
                if (this.resource == null) {
                    missing.append(" resource");
                }
                if (this.lockedBy == null) {
                    missing.append(" lockedBy");
                }
                if (this.createdAt == null) {
                    missing.append(" createdAt");
                }
                if (this.updatedAt == null) {
                    missing.append(" updatedAt");
                }
                throw new IllegalStateException("Missing required properties:" + String.valueOf(missing));
            }
            return new AutoValue_Lock(this.resource, this.lockedBy, this.createdAt, this.updatedAt);
        }
    }
}

