/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.cluster.nodes;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.graylog2.cluster.Node;
import org.graylog2.database.MongoEntity;
import org.joda.time.DateTime;

public abstract class NodeDto
implements Node,
MongoEntity {
    @Override
    public String id() {
        return this.getId();
    }

    @JsonProperty(value="object_id")
    @Nullable
    public abstract String getObjectId();

    @JsonProperty(value="id")
    public abstract String getId();

    @Override
    @JsonProperty(value="node_id")
    public String getNodeId() {
        return this.getId();
    }

    @Override
    @JsonProperty(value="transport_address")
    public abstract String getTransportAddress();

    @Override
    @JsonProperty(value="last_seen")
    @Nullable
    public abstract DateTime getLastSeen();

    @Override
    @JsonProperty(value="hostname")
    @Nullable
    public abstract String getHostname();

    @Override
    @JsonProperty(value="is_leader")
    public abstract boolean isLeader();

    @Override
    @JsonProperty(value="short_node_id")
    public String getShortNodeId() {
        return this.getId().split("-")[0];
    }

    public Map<String, Object> toEntityParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("node_id", this.getNodeId());
        params.put("transport_address", this.getTransportAddress());
        params.put("is_leader", this.isLeader());
        if (Objects.nonNull(this.getHostname())) {
            params.put("hostname", this.getHostname());
        }
        return params;
    }

    public static abstract class Builder<B extends Builder<B>> {
        @JsonProperty(value="_id")
        public abstract B setObjectId(String var1);

        @JsonProperty(value="node_id")
        public abstract B setId(String var1);

        @JsonProperty(value="transport_address")
        public abstract B setTransportAddress(String var1);

        @JsonProperty(value="last_seen")
        public abstract B setLastSeen(DateTime var1);

        @JsonProperty(value="hostname")
        public abstract B setHostname(String var1);

        @JsonProperty(value="is_leader")
        public abstract B setLeader(boolean var1);
    }
}

